/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cfg;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.cfg.CfgProvider;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.PropertiesConfigFile;
import de.mhus.lib.core.io.FileWatch;
import java.io.File;
import java.io.IOException;

public class PropertiesCfgFileWatch
extends MLog
implements CfgProvider {
    private FileWatch fileWatch;
    private File file;
    private IConfig config;
    private String name;

    public PropertiesCfgFileWatch() {
    }

    public PropertiesCfgFileWatch(File file) {
        this.setFile(file);
    }

    @Override
    public void doStart(final String name) {
        this.name = name;
        this.load();
        MApi.getCfgUpdater().doUpdate(name);
        this.fileWatch = new FileWatch(this.file, new FileWatch.Listener(){

            @Override
            public void onFileChanged(FileWatch fileWatch) {
                PropertiesCfgFileWatch.this.log().d("update cfg properties file", PropertiesCfgFileWatch.this.file);
                PropertiesCfgFileWatch.this.load();
                MApi.getCfgUpdater().doUpdate(name);
            }

            @Override
            public void onFileWatchError(FileWatch fileWatch, Throwable t) {
                PropertiesCfgFileWatch.this.log().d(PropertiesCfgFileWatch.this.file, t);
            }
        });
        this.fileWatch.doStart();
    }

    private void load() {
        try {
            this.config = new PropertiesConfigFile(this.file);
        }
        catch (IOException e) {
            this.log().d(this.file, e);
        }
    }

    @Override
    public void doStop() {
        if (this.fileWatch != null) {
            this.fileWatch.doStop();
            this.fileWatch = null;
        }
    }

    @Override
    public IConfig getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }
}

