/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.basics.Named;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MTimerTask;
import java.lang.ref.WeakReference;
import java.util.TimerTask;

public class MWeakTimerTask
extends TimerTask
implements Named {
    private boolean canceled = false;
    private String name;
    private WeakReference<TimerTask> task;

    public MWeakTimerTask(TimerTask task) {
        this.task = new WeakReference<TimerTask>(task);
        this.setName(MSystem.getClassName(this));
    }

    @Override
    public final void run() {
        boolean error = false;
        try {
            this.doit();
        }
        catch (Throwable t) {
            try {
                this.onError(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            error = true;
        }
        try {
            this.onFinal(error);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onError(Throwable t) {
        t.printStackTrace();
    }

    protected void onFinal(boolean isError) {
    }

    protected void doit() throws Exception {
        if (this.task == null) {
            this.cancel();
            return;
        }
        TimerTask taskTask = (TimerTask)this.task.get();
        if (taskTask == null || MTimerTask.getStatus(taskTask) == 3) {
            this.cancel();
            return;
        }
        taskTask.run();
    }

    @Override
    public boolean cancel() {
        this.setCanceled(true);
        return super.cancel();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

