/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class WeakList<E>
extends AbstractList<E> {
    private LinkedList<WeakReference<E>> items = new LinkedList();

    public WeakList() {
    }

    public WeakList(Collection<E> c) {
        this.addAll(0, c);
    }

    @Override
    public void add(int index, E element) {
        this.items.add(index, new WeakReference<E>(element));
    }

    @Override
    public E get(int index) {
        WeakReference<E> weak = this.items.get(index);
        return (E)weak.get();
    }

    @Override
    public int size() {
        this.cleanupWeak();
        return this.items.size();
    }

    public void cleanupWeak() {
        this.items.removeIf(i -> i.get() == null);
    }

    @Override
    public Iterator<E> iterator() {
        this.cleanupWeak();
        return this.toList().iterator();
    }

    private AbstractList<E> toList() {
        LinkedList out = new LinkedList();
        this.items.forEach(i -> {
            Object v = i.get();
            if (v != null) {
                out.add(v);
            }
        });
        return out;
    }
}

