/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.MCrypt;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SecureString
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected byte[] data;
    protected int length;

    public SecureString() {
    }

    public SecureString(String data) {
        int n = this.length = data == null ? 0 : data.length();
        if (data == null) {
            return;
        }
        this.data = MCrypt.obfuscate(MString.toBytes(data));
    }

    public String value() {
        if (this.data == null) {
            return null;
        }
        return MString.toString(MCrypt.unobfuscate(this.data));
    }

    public int length() {
        return this.length;
    }

    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        if (this.data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.data.length);
            out.write(this.data);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.length = in.readInt();
        int len = in.readInt();
        if (len < 0) {
            this.data = null;
        } else {
            this.data = new byte[len];
            MFile.readBinary(in, this.data, 0, len);
        }
    }

    public String toString() {
        return "[***]";
    }
}

