/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import java.util.LinkedList;

public class ByteBuffer {
    private int extend = 10240;
    private LinkedList<byte[]> list = new LinkedList();
    private byte[] last = null;
    private int lastPos = 0;
    private byte[] buffer = new byte[1];
    private int size = 0;
    private int firstPos = 0;

    public ByteBuffer() {
    }

    public ByteBuffer(int extend) {
        if (extend < 1) {
            throw new RuntimeException("Extend to less");
        }
        this.extend = extend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(byte in) {
        ByteBuffer byteBuffer = this;
        synchronized (byteBuffer) {
            this.buffer[0] = in;
            this.append(this.buffer, 0, 1);
        }
    }

    public void append(byte[] in) {
        this.append(in, 0, in.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(byte[] in, int offset, int len) {
        ByteBuffer byteBuffer = this;
        synchronized (byteBuffer) {
            while (len > 0) {
                if (this.last == null) {
                    this.last = new byte[Math.max(this.extend, len)];
                    this.list.addLast(this.last);
                    this.lastPos = 0;
                }
                if (len < this.last.length - this.lastPos) {
                    System.arraycopy(in, offset, this.last, this.lastPos, len);
                    this.lastPos += len;
                    this.size += len;
                    len = 0;
                    continue;
                }
                int max = this.last.length - this.lastPos;
                System.arraycopy(in, offset, this.last, this.lastPos, max);
                offset += max;
                len -= max;
                this.size += max;
                this.last = null;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public byte[] toByte() {
        byte[] out = new byte[this.size];
        int pos = 0;
        boolean first = true;
        for (byte[] part : this.list) {
            int len = part.length;
            if (pos + len >= out.length) {
                len = out.length - pos;
            }
            int fp = 0;
            if (first) {
                fp = this.firstPos;
                first = false;
            }
            System.arraycopy(part, fp, out, pos, len);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ByteBuffer byteBuffer = this;
        synchronized (byteBuffer) {
            this.list.clear();
            this.size = 0;
            this.lastPos = 0;
            this.firstPos = 0;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shift() {
        ByteBuffer byteBuffer = this;
        synchronized (byteBuffer) {
            if (this.list.isEmpty()) {
                return -1;
            }
            byte[] first = this.list.getFirst();
            byte b = first[this.firstPos];
            ++this.firstPos;
            if (this.firstPos >= first.length) {
                this.list.removeFirst();
                this.firstPos = 0;
            }
            --this.size;
            return b;
        }
    }
}

