/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.definition.DefRoot;
import de.mhus.lib.core.definition.IDefAttribute;
import de.mhus.lib.core.definition.IDefDefinition;
import de.mhus.lib.core.strategy.AbstractOperation;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationDescription;
import de.mhus.lib.core.strategy.OperationResult;
import de.mhus.lib.core.strategy.Successful;
import de.mhus.lib.core.strategy.TaskContext;
import de.mhus.lib.core.util.Version;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.NotFoundException;
import de.mhus.lib.form.definition.FmText;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;

public abstract class OperationToIfcProxy
extends AbstractOperation {
    public static final String METHOD = "method";
    public static final String PARAMETER = "parameter";
    public static final String TYPE = "type";
    public static final String SERIALISED = ":s";
    public static final String PARAMETERTYPE = "ptype";
    public static final String NULL = ":null";
    public static final String PARAMETERORGTYPE = "otype";

    protected abstract Class<?> getInterfaceClass();

    protected abstract Object getInterfaceObject();

    protected abstract Version getInterfaceVersion();

    protected abstract void initOperationDescription(HashMap<String, String> var1);

    @Override
    protected OperationResult doExecute2(TaskContext context) throws Exception {
        Class<?> clazz = this.getInterfaceClass();
        ClassLoader cl = this.getClass().getClassLoader();
        IProperties p = context.getParameters();
        String methodName = p.getString(METHOD);
        Method method = null;
        block2: for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            Parameter[] mp = m.getParameters();
            for (int i = 0; i < mp.length; ++i) {
                String mpType = mp[i].getType().getCanonicalName();
                String reqType = p.getString(PARAMETERTYPE + i, null);
                if (reqType != null && reqType.equals("null")) {
                    reqType = p.getString(TYPE + i, null);
                }
                if (reqType == null || !mpType.equals(reqType)) continue block2;
            }
            if (p.containsKey(PARAMETERTYPE + mp.length)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new NotFoundException(new Object[]{"Method not found", methodName, p});
        }
        int pcount = method.getParameterCount();
        Object[] params = new Object[pcount];
        for (int i = 0; i < pcount; ++i) {
            params[i] = this.toObject(p.get(PARAMETER + i), p.getString(TYPE + i), cl);
        }
        Object obj = this.getInterfaceObject();
        try {
            Object ret = method.invoke(obj, params);
            return new Successful((Operation)this, "", ret);
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new MException(new Object[]{e.toString()});
        }
    }

    private Object toObject(Object value, String type, ClassLoader cl) throws ClassNotFoundException, IOException {
        if (type != null && type.equals(NULL)) {
            return null;
        }
        if (value == null) {
            return MCast.getDefaultPrimitive(type);
        }
        if (type != null && type.equals(SERIALISED)) {
            return MCast.unserializeFromString(String.valueOf(value), cl);
        }
        Class<?> t = cl.loadClass(type);
        return MCast.toType(value, t, null);
    }

    @Override
    protected OperationDescription createDescription() {
        Class<?> clazz = this.getInterfaceClass();
        DefRoot form = new DefRoot(new IDefDefinition[0]);
        for (Method m : clazz.getMethods()) {
            StringBuilder desc = new StringBuilder();
            desc.append(m.getReturnType().getCanonicalName());
            for (Parameter p : m.getParameters()) {
                desc.append(",");
                desc.append(p.getName()).append(":").append(p.getType());
            }
            FmText def = new FmText(m.getName(), m.getName(), desc.toString(), new IDefAttribute[0]);
            form.addDefinition(def);
        }
        OperationDescription out = new OperationDescription(this.getUuid(), clazz.getPackage().getName(), clazz.getSimpleName(), this.getInterfaceVersion(), this, this.getClass().getCanonicalName(), form);
        out.setParameters(new HashMap<String, String>());
        this.initOperationDescription(out.getParameters());
        return out;
    }
}

