/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.net;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Subnet {
    private final int bytesSubnetCount;
    private final BigInteger bigMask;
    private final BigInteger bigSubnetMasked;

    public Subnet(InetAddress subnetAddress, int bits) {
        this.bytesSubnetCount = subnetAddress.getAddress().length;
        this.bigMask = BigInteger.valueOf(-1L).shiftLeft(this.bytesSubnetCount * 8 - bits);
        this.bigSubnetMasked = new BigInteger(subnetAddress.getAddress()).and(this.bigMask);
    }

    public Subnet(InetAddress subnetAddress, InetAddress mask) {
        this.bytesSubnetCount = subnetAddress.getAddress().length;
        this.bigMask = null == mask ? BigInteger.valueOf(-1L) : new BigInteger(mask.getAddress());
        this.bigSubnetMasked = new BigInteger(subnetAddress.getAddress()).and(this.bigMask);
    }

    public static Subnet createInstance(String subnetMask) throws UnknownHostException {
        String[] stringArr = subnetMask.split("/");
        if (2 > stringArr.length) {
            return new Subnet(InetAddress.getByName(stringArr[0]), null);
        }
        if (stringArr[1].contains(".") || stringArr[1].contains(":")) {
            return new Subnet(InetAddress.getByName(stringArr[0]), InetAddress.getByName(stringArr[1]));
        }
        return new Subnet(InetAddress.getByName(stringArr[0]), Integer.parseInt(stringArr[1]));
    }

    public boolean isInNet(String address) {
        try {
            return this.isInNet(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean isInNet(InetAddress address) {
        byte[] bytesAddress = address.getAddress();
        if (this.bytesSubnetCount != bytesAddress.length) {
            return false;
        }
        BigInteger bigAddress = new BigInteger(bytesAddress);
        return bigAddress.and(this.bigMask).equals(this.bigSubnetMasked);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return this.bigSubnetMasked.equals(other.bigSubnetMasked) && this.bigMask.equals(other.bigMask) && this.bytesSubnetCount == other.bytesSubnetCount;
    }

    public final int hashCode() {
        return this.bytesSubnetCount;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Subnet.bigInteger2IpString(buf, this.bigSubnetMasked, this.bytesSubnetCount);
        buf.append('/');
        Subnet.bigInteger2IpString(buf, this.bigMask, this.bytesSubnetCount);
        return buf.toString();
    }

    private static void bigInteger2IpString(StringBuilder buf, BigInteger bigInteger, int displayBytes) {
        boolean isIPv4 = 4 == displayBytes;
        byte[] bytes = bigInteger.toByteArray();
        int diffLen = displayBytes - bytes.length;
        int fillByte = 0 > bytes[0] ? -1 : 0;
        for (int i = 0; i < displayBytes; ++i) {
            if (0 < i && !isIPv4 && i % 2 == 0) {
                buf.append(':');
            } else if (0 < i && isIPv4) {
                buf.append('.');
            }
            int integer = 0xFF & (i < diffLen ? fillByte : bytes[i - diffLen]);
            if (!isIPv4 && 16 > integer) {
                buf.append('0');
            }
            buf.append(isIPv4 ? Integer.valueOf(integer) : Integer.toHexString(integer));
        }
    }
}

