/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.json;

import de.mhus.lib.core.MJson;
import de.mhus.lib.core.json.TransformHelper;
import de.mhus.lib.core.json.TransformStrategy;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.errors.NotSupportedException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class SimpleObjectTransformer
extends TransformStrategy {
    @Override
    public Object jsonToPojo(JsonNode from, Class<?> type, TransformHelper helper) throws NotSupportedException {
        Object to;
        try {
            to = helper.createObject(type);
        }
        catch (Exception e1) {
            throw new NotSupportedException(new Object[]{type, e1});
        }
        if (from.size() == 1) {
            String singleName = (String)from.getFieldNames().next();
            if ("_collection".equals(singleName)) {
                LinkedList<Object> out = new LinkedList<Object>();
                for (JsonNode n : from.get(0)) {
                    out.add(this.jsonToPojo(n, null, helper.incLevel()));
                }
                helper.decLevel();
                return out;
            }
            if ("_map".equals(singleName)) {
                HashMap<String, Object> out = new HashMap<String, Object>();
                Iterator nameIter = from.getFieldNames();
                while (nameIter.hasNext()) {
                    String name = (String)nameIter.next();
                    JsonNode on = from.get(name);
                    out.put(name, this.jsonToPojo(on, null, helper.incLevel()));
                }
                helper.decLevel();
                return out;
            }
        }
        PojoModel model = helper.createPojoModel(to);
        for (PojoAttribute attr : model) {
            String name = attr.getName();
            Class<?> aType = attr.getType();
            JsonNode json = from.get(helper.getPrefix() + name);
            try {
                LinkedList<Object> l;
                if (json == null || !attr.canWrite()) continue;
                if (aType == Boolean.class || aType == Boolean.TYPE) {
                    attr.set(to, json.asBoolean(false));
                    continue;
                }
                if (aType == Integer.class || aType == Integer.TYPE) {
                    attr.set(to, json.asInt(0));
                    continue;
                }
                if (aType == String.class) {
                    attr.set(to, json.asText());
                    continue;
                }
                if (aType == UUID.class) {
                    try {
                        attr.set(to, UUID.fromString(json.asText()));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (aType.isEnum()) {
                    Object c;
                    ?[] cons = aType.getEnumConstants();
                    int ord = json.asInt(0);
                    Object t = c = cons.length > 0 ? (Object)cons[0] : null;
                    if (ord >= 0 && ord < cons.length) {
                        c = cons[ord];
                    }
                    attr.set(to, c);
                    continue;
                }
                if (aType == Date.class) {
                    try {
                        attr.set(to, new Date(json.asLong(0L)));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (Map.class.isAssignableFrom(aType)) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Iterator iter = json.getFieldNames();
                    while (iter.hasNext()) {
                        String n = (String)iter.next();
                        map.put(n, SimpleObjectTransformer.getValue(json.get(name), helper));
                    }
                    attr.set(to, map);
                    continue;
                }
                if (Collection.class.isAssignableFrom(aType) && json instanceof ArrayNode) {
                    LinkedList<Object> list = new LinkedList<Object>();
                    ArrayNode array = (ArrayNode)json;
                    for (JsonNode a : array) {
                        list.add(SimpleObjectTransformer.getValue(a, helper));
                    }
                    continue;
                }
                if (aType == String[].class) {
                    try {
                        l = new LinkedList<Object>();
                        for (JsonNode i : json) {
                            l.add(i.asText());
                        }
                        attr.set(to, l.toArray(new String[l.size()]));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (aType.isArray()) {
                    try {
                        l = new LinkedList();
                        for (JsonNode i : json) {
                            Object obj = this.jsonToPojo(i, aType, helper);
                            l.add(obj);
                        }
                        attr.set(to, l.toArray((Object[])Array.newInstance(aType, l.size())));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                Object obj = this.jsonToPojo(json, aType, helper);
                attr.set(to, obj);
            }
            catch (Throwable t) {
                helper.log("ERROR " + name, t);
                throw new NotSupportedException(new Object[]{name, t});
            }
        }
        return to;
    }

    @Override
    public JsonNode pojoToJson(Object from, TransformHelper helper) throws NotSupportedException {
        ObjectNode to = MJson.createObjectNode();
        if (from instanceof Object[]) {
            ArrayNode array = to.arrayNode();
            to.put("array", (JsonNode)array);
            for (Object i : (Object[])from) {
                JsonNode o = this.pojoToJson(i, helper.incLevel());
                array.add(o);
            }
            helper.decLevel();
            return to;
        }
        if (from instanceof Collection) {
            Collection obj = (Collection)from;
            ArrayNode array = to.arrayNode();
            to.put("_collection", (JsonNode)array);
            for (Object o : obj) {
                JsonNode item = this.pojoToJson(o, helper.incLevel());
                array.add(item);
            }
            helper.decLevel();
            return to;
        }
        if (from instanceof Map) {
            ObjectNode obj = to.objectNode();
            to.put("_map", (JsonNode)obj);
            for (Map.Entry e : ((Map)from).entrySet()) {
                JsonNode on = this.pojoToJson(e.getValue(), helper);
                obj.put(String.valueOf(e.getKey()), on);
            }
            helper.decLevel();
            return to;
        }
        PojoModel model = helper.createPojoModel(from);
        for (PojoAttribute attr : model) {
            try {
                Object obj;
                ArrayNode array;
                Object value = attr.get(from);
                String name = attr.getName();
                if (value == null) {
                    to.put(name, (String)null);
                    continue;
                }
                if (value instanceof Boolean) {
                    to.put(name, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    to.put(name, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof String) {
                    to.put(name, (String)value);
                    continue;
                }
                if (value.getClass().isEnum()) {
                    to.put(name, ((Enum)value).ordinal());
                    to.put(name + "_", ((Enum)value).name());
                    continue;
                }
                if (value instanceof Date) {
                    to.put(name, ((Date)value).getTime());
                    continue;
                }
                if (value instanceof String[]) {
                    array = to.arrayNode();
                    to.put(name, (JsonNode)array);
                    for (String string : (String[])value) {
                        array.add(string);
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    array = to.arrayNode();
                    to.put(name, (JsonNode)array);
                    for (Object object : (Object[])value) {
                        JsonNode o = this.pojoToJson(object, helper.incLevel());
                        array.add(o);
                    }
                    continue;
                }
                if (value instanceof Map) {
                    obj = to.objectNode();
                    to.put(name, (JsonNode)obj);
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        obj.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    obj = (Collection)value;
                    ArrayNode array2 = to.arrayNode();
                    to.put(name, (JsonNode)array2);
                    Iterator iterator = obj.iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        JsonNode jsonNode = this.pojoToJson(o, helper.incLevel());
                        array2.add(jsonNode);
                    }
                    continue;
                }
                if (value instanceof Class) {
                    to.put(attr.getName(), ((Class)value).getSimpleName());
                    continue;
                }
                if (value instanceof UUID) {
                    to.put(attr.getName(), String.valueOf(value));
                    continue;
                }
                if (!helper.checkLevel()) {
                    throw new NotSupportedException(new Object[]{"too deep:" + attr.getName() + " " + value.getClass().getSimpleName()});
                }
                JsonNode sub = this.pojoToJson(value, helper.incLevel());
                to.put(attr.getName(), sub);
            }
            catch (Throwable t) {
                helper.log(null, t);
                throw new NotSupportedException(new Object[]{t});
            }
        }
        return to;
    }

    public static Object getValue(JsonNode node, TransformHelper helper) {
        Object out = null;
        if (node == null) {
            return null;
        }
        try {
            if (node.isTextual()) {
                out = node.asText();
            } else if (node.isNull()) {
                out = null;
            } else if (node.isBigDecimal()) {
                out = node.getDecimalValue();
            } else if (node.isBigInteger()) {
                out = node.getBigIntegerValue();
            } else if (node.isBinary()) {
                out = node.getBinaryValue();
            } else if (node.isBoolean()) {
                out = node.getBooleanValue();
            } else if (node.isDouble()) {
                out = node.getDoubleValue();
            } else if (node.isInt()) {
                out = node.getIntValue();
            } else if (node.isLong()) {
                out = node.getLongValue();
            } else if (node.isNumber()) {
                out = node.getNumberValue();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }
}

