/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MPeriod;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.cfg.CfgInt;
import de.mhus.lib.core.cfg.CfgLong;
import de.mhus.lib.core.crypt.MRandom;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.LinkedList;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class MBouncy {
    protected static final String ALGORITHM_RSA = "RSA";
    protected static final String PROVIDER = "BC";
    protected static final String TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    protected static final String ALGORITHM_AES = "AES";
    private static final Charset STRING_ENCODING = MString.CHARSET_CHARSET_UTF_8;
    public static final RSA_KEY_SIZE RSA_KEY_SIZE_DEFAULT = RSA_KEY_SIZE.B1024;
    private static LinkedList<KeyPair> keyPool = new LinkedList();
    private static long keyPoolUpdate = 0L;
    private static CfgLong CFG_POOL_UPDATE_TIME = new CfgLong((Object)MBouncy.class, "poolUpdateTime", 600000L);
    private static CfgInt CFG_POOL_SIZE = new CfgInt((Object)MBouncy.class, "poolSize", 10);

    public static void init() {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static KeyPair generateRsaKey(RSA_KEY_SIZE size) throws NoSuchAlgorithmException, NoSuchProviderException {
        MBouncy.init();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM_RSA, PROVIDER);
        keyGen.initialize(size.getBits());
        KeyPair key = keyGen.generateKeyPair();
        return key;
    }

    public static PublicKey getPublicKey(String key) {
        try {
            MBouncy.init();
            byte[] encodedKey = MBouncy.decodeBase64(key);
            X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(encodedKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA, PROVIDER);
            return keyFactory.generatePublic(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey getPrivateKey(String key) {
        try {
            MBouncy.init();
            byte[] encodedKey = MBouncy.decodeBase64(key);
            PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(encodedKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA, PROVIDER);
            return keyFactory.generatePrivate(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPublicKey(KeyPair key) {
        return MBouncy.encodeBase64(new X509EncodedKeySpec(key.getPublic().getEncoded()).getEncoded());
    }

    public static String getPrivateKey(KeyPair key) {
        return MBouncy.encodeBase64(new PKCS8EncodedKeySpec(key.getPrivate().getEncoded()).getEncoded());
    }

    public static byte[] encryptRsa117(byte[] text, PublicKey key) throws Exception {
        MBouncy.init();
        byte[] cipherText = null;
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(1, key);
        cipherText = cipher.doFinal(text);
        return cipherText;
    }

    public static byte[] encryptRsa(byte[] text, PublicKey key) throws Exception {
        byte[] out;
        int len;
        MBouncy.init();
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(1, key);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int start = 0;
        while (true) {
            if ((len = text.length - start) <= 117) break;
            out = cipher.doFinal(text, start, 117);
            os.write(out);
            start += 117;
        }
        out = cipher.doFinal(text, start, len);
        os.write(out);
        return os.toByteArray();
    }

    public static byte[] decryptRsa(byte[] text, PrivateKey key) throws Exception {
        MBouncy.init();
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(2, key);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int start = 0;
        while (true) {
            int len;
            if ((len = text.length - start) > 128) {
                len = 128;
            }
            byte[] out = cipher.doFinal(text, start, len);
            os.write(out);
            if (start + len >= text.length) break;
            start += len;
        }
        return os.toByteArray();
    }

    public static String encryptRsa117(String text, PublicKey key) throws Exception {
        byte[] cipherText = MBouncy.encryptRsa(text.getBytes(STRING_ENCODING), key);
        String encryptedText = MBouncy.encodeBase64(cipherText);
        return encryptedText;
    }

    public static byte[] decryptRsa117(byte[] text, PrivateKey key) throws Exception {
        MBouncy.init();
        byte[] dectyptedText = null;
        Cipher cipher = Cipher.getInstance(TRANSFORMATION, PROVIDER);
        cipher.init(2, key);
        dectyptedText = cipher.doFinal(text);
        return dectyptedText;
    }

    public static String decryptRsa117(String text, PrivateKey key) throws Exception {
        byte[] dectyptedText = MBouncy.decryptRsa(MBouncy.decodeBase64(text), key);
        String result = new String(dectyptedText, STRING_ENCODING);
        return result;
    }

    public static String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decodeBase64(String text) {
        return Base64.getDecoder().decode(text);
    }

    public static byte[] createRandom(int size) {
        byte[] out = new byte[size];
        MRandom rnd = MApi.lookup(MRandom.class);
        for (int i = 0; i < out.length; ++i) {
            out[i] = rnd.getByte();
        }
        return out;
    }

    public static byte[] encryptAes(byte[] key, byte[] data) {
        MBouncy.init();
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES, PROVIDER);
            Key skeySpec = MBouncy.generateAesKeySpec(key);
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(data);
            return encrypted;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptAes(byte[] key, String data) {
        byte[] enc = MBouncy.encryptAes(key, data.getBytes(STRING_ENCODING));
        return MBouncy.encodeBase64(enc);
    }

    public static Key generateAesKeySpec(byte[] key) {
        SecretKeySpec k = new SecretKeySpec(key, ALGORITHM_AES);
        return k;
    }

    public static byte[] decryptAes(byte[] key, byte[] encrypted) {
        MBouncy.init();
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES, PROVIDER);
            Key skeySpec = MBouncy.generateAesKeySpec(key);
            cipher.init(2, skeySpec);
            byte[] decrypted = cipher.doFinal(encrypted);
            return decrypted;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptAes(byte[] key, String encrypted) {
        byte[] dec = MBouncy.decryptAes(key, MBouncy.decodeBase64(encrypted));
        return new String(dec, STRING_ENCODING);
    }

    public static synchronized KeyPair getRsaKeyFromPool() {
        if (MPeriod.isTimeOut(keyPoolUpdate, (Long)CFG_POOL_UPDATE_TIME.value())) {
            if (keyPool.size() > 0) {
                keyPool.removeFirst();
            }
            keyPoolUpdate = System.currentTimeMillis();
        }
        if (keyPool.size() < (Integer)CFG_POOL_SIZE.value()) {
            try {
                KeyPair key = MBouncy.generateRsaKey(RSA_KEY_SIZE_DEFAULT);
                keyPool.add(key);
                return key;
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new RuntimeException(e);
            }
        }
        int pos = (int)(Math.random() * (double)keyPool.size());
        return keyPool.get(pos);
    }

    public static enum RSA_KEY_SIZE {
        B1024,
        B2048,
        B4096;

        private int bits = MCast.toint(this.name().substring(1), 1024);

        public int getBits() {
            return this.bits;
        }
    }
}

