/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.MDate;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.lang.Value;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConsoleTable {
    public static final String SEPARATOR_LINE = "---";
    private static final int MIN_TABLE_WIDTH = 80;
    public List<Column> header = new ArrayList<Column>();
    public List<List<String[]>> content = new ArrayList<List<String[]>>();
    private int maxColSize = -1;
    private boolean lineSpacer = false;
    private boolean multiLine = true;
    private int maxTableWidth = 0;
    private String colSeparator = " | ";
    private boolean acceptHorizontalLine = false;
    private boolean cellSpacer = true;
    private int tableWidth;
    private int definedTableWidth = 0;

    public ConsoleTable() {
    }

    public ConsoleTable(String options) {
        if (options != null) {
            options = options.trim();
            MProperties o = MProperties.explodeToMProperties(options);
            this.setFull(o.getBoolean("full", false));
        } else {
            this.fitToConsole();
        }
    }

    public ConsoleTable(boolean full) {
        this.setFull(full);
    }

    public void setFull(boolean full) {
        if (full) {
            this.setMaxColSize(0);
        } else {
            this.fitToConsole();
        }
    }

    public Row addRow() {
        return new Row(this.addIntRow());
    }

    private List<String[]> addIntRow() {
        ArrayList<String[]> row = new ArrayList<String[]>();
        this.content.add(row);
        return row;
    }

    public void addRowValues(Object ... values) {
        List<String[]> row = this.addIntRow();
        for (Object v : values) {
            row.add(this.splitInLines(v));
        }
    }

    protected String[] splitInLines(Object v) {
        if (v == null) {
            return new String[]{""};
        }
        if (this.multiLine) {
            if (v instanceof Map) {
                Map m = (Map)v;
                LinkedList<String> out = new LinkedList<String>();
                for (Map.Entry entry : m.entrySet()) {
                    out.add(entry.getKey() + "=" + entry.getValue());
                }
                return out.toArray(new String[out.size()]);
            }
            if (v instanceof Collection) {
                LinkedList<String> out = new LinkedList<String>();
                for (Object entry : (Collection)v) {
                    out.add(String.valueOf(entry));
                }
                return out.toArray(new String[out.size()]);
            }
            if (v instanceof Throwable) {
                LinkedList<String> out = new LinkedList<String>();
                Throwable t = (Throwable)v;
                if (this.maxColSize > 0) {
                    out.addAll(MString.splitCollection(t.toString(), this.maxColSize));
                } else {
                    out.add(t.toString());
                }
                for (StackTraceElement st : t.getStackTrace()) {
                    out.add("  at " + st);
                }
                return out.toArray(new String[out.size()]);
            }
            if (v.getClass().isArray()) {
                Object[] a = (Object[])v;
                String[] out = new String[a.length];
                for (int i = 0; i < a.length; ++i) {
                    out[i] = MString.toString(a[i]);
                }
                return out;
            }
            if (v instanceof Date) {
                return new String[]{MDate.toIso8601((Date)v)};
            }
            return String.valueOf(v).split("\n");
        }
        return new String[]{String.valueOf(v)};
    }

    public List<Column> getHeader() {
        return this.header;
    }

    public void setHeaderValues(String ... values) {
        List<Column> row = this.getHeader();
        row.clear();
        for (String v : values) {
            row.add(new Column(v));
        }
    }

    public void print(Console console) {
        this.setMaxColSize(console.getWidth());
        this.print((PrintStream)console);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        this.updateHeaderSizes();
        String headerLine = this.getHeaderRow();
        out.println(headerLine);
        if (this.cellSpacer) {
            out.println(this.underline());
        }
        boolean first = true;
        for (List<String[]> row : this.content) {
            if (!first && this.lineSpacer) {
                out.println();
            }
            int rowHeight = this.getRowHeight(row);
            for (int l = 0; l < rowHeight; ++l) {
                out.println(this.getRow(row, l));
            }
            first = false;
        }
    }

    public void print(PrintWriter out) {
        this.updateHeaderSizes();
        String headerLine = this.getHeaderRow();
        out.println(headerLine);
        if (this.cellSpacer) {
            out.println(this.underline());
        }
        boolean first = true;
        for (List<String[]> row : this.content) {
            if (!first && this.lineSpacer) {
                out.println();
            }
            int rowHeight = this.getRowHeight(row);
            for (int l = 0; l < rowHeight; ++l) {
                out.println(this.getRow(row, l));
            }
            first = false;
        }
    }

    private int getRowHeight(List<String[]> row) {
        if (!this.multiLine) {
            return 1;
        }
        int height = 1;
        for (String[] cell : row) {
            height = Math.max(height, cell.length);
        }
        return height;
    }

    private String underline() {
        return MString.rep('-', this.tableWidth);
    }

    private String getRow(List<String[]> row, int cellLine) {
        String[] row0;
        if (this.acceptHorizontalLine && row.size() == 1 && (row0 = row.get(0)) != null && row0.length == 1 && row0[0] != null && row0[0].equals(SEPARATOR_LINE)) {
            return this.underline();
        }
        StringBuilder line = new StringBuilder();
        int c = 0;
        for (String[] cells : row) {
            Column h;
            if (c > this.header.size() || (h = this.header.get(c)).width == 0) continue;
            String cell = this.getCellLine(cells, cellLine);
            if ((cell = cell.replaceAll("\n", "")).length() > h.width) {
                cell = MString.truncateNice(cell, h.width);
            }
            if (this.cellSpacer) {
                if (h.width > 0) {
                    line.append(String.format("%-" + h.width + "s", cell));
                }
            } else {
                line.append(cell);
            }
            if (c + 1 < row.size()) {
                line.append(this.colSeparator);
            }
            if (h.last) break;
            ++c;
        }
        return line.toString();
    }

    private String getHeaderRow() {
        StringBuilder line = new StringBuilder();
        for (Column h : this.header) {
            String cell = h.title;
            if (cell.length() > h.width) {
                cell = MString.truncateNice(cell, h.width);
            }
            cell = cell.replaceAll("\n", "");
            if (this.cellSpacer) {
                if (h.width > 0) {
                    line.append(String.format("%-" + h.width + "s", cell));
                }
            } else {
                line.append(cell);
            }
            if (h.last) continue;
            line.append(this.colSeparator);
        }
        return line.toString();
    }

    private String getCellLine(String[] cells, int line) {
        if (!this.multiLine) {
            if (line == 0) {
                return MString.join(cells, ' ');
            }
            return "";
        }
        if (cells == null || line < 0 || line >= cells.length) {
            return "";
        }
        return cells[line];
    }

    private void updateHeaderSizes() {
        int delta;
        this.tableWidth = 0;
        if (this.header.size() == 0) {
            return;
        }
        this.header.forEach(h -> {
            if (h.title == null) {
                h.title = "";
            }
            ((Column)h).last = false;
        });
        this.header.get(this.header.size() - 1).last = true;
        for (Column column : this.header) {
            column.contentWidth = column.title.length();
        }
        for (List list : this.content) {
            int c = 0;
            for (String[] cells : list) {
                if (c >= this.header.size()) continue;
                Column h2 = this.header.get(c);
                for (String cellContent : cells) {
                    int cellSize = cellContent != null ? cellContent.length() : 0;
                    h2.contentWidth = Math.max(h2.contentWidth, cellSize);
                }
                ++c;
            }
        }
        Value<Integer> weight = new Value<Integer>(0);
        Value<Integer> value = new Value<Integer>(0);
        this.header.forEach(h -> {
            int width = h.contentWidth;
            if (h.minWidth > 0) {
                width = Math.max(width, h.minWidth);
            }
            if (h.maxWidth > 0) {
                width = Math.min(width, h.maxWidth);
            } else if (this.maxColSize > 0) {
                width = Math.min(width, this.maxColSize);
            }
            if (this.maxTableWidth > 0 && h.weight > 0) {
                weight.value = (Integer)weight.value + h.weight;
                weightWidth.value = (Integer)weightWidth.value + width;
            }
            this.tableWidth += width;
            if (!((Column)h).last && this.colSeparator != null) {
                this.tableWidth += this.colSeparator.length();
            }
            ((Column)h).width = width;
        });
        if ((Integer)weight.value > 0) {
            delta = this.maxTableWidth - (this.tableWidth - (Integer)value.value);
            if (delta > 0) {
                this.header.forEach(h -> {
                    if (h.weight > 0) {
                        int width = h.contentWidth;
                        this.tableWidth -= width;
                        width = delta * h.weight / (Integer)weight.value;
                        this.tableWidth += width;
                        ((Column)h).width = width;
                    }
                });
            }
        } else if (this.maxTableWidth > 0 && this.tableWidth > this.maxTableWidth) {
            int max = this.maxTableWidth / this.header.size();
            this.header.forEach(h -> {
                int min = Math.max(10, h.minWidth);
                int d = Math.max(max, min);
                if (((Column)h).width > d) {
                    this.tableWidth = this.tableWidth + d - ((Column)h).width;
                    ((Column)h).width = d;
                }
            });
        }
        if (this.maxTableWidth > 0 && this.tableWidth > this.maxTableWidth) {
            for (int i = this.header.size() - 1; i >= 0; --i) {
                Column h3 = this.header.get(i);
                int width = h3.contentWidth;
                this.tableWidth -= width;
                h3.width = 0;
                h3.last = true;
                if (this.tableWidth >= this.maxTableWidth) continue;
                width = this.maxTableWidth - this.tableWidth;
                h3.width = width;
                this.tableWidth += width;
                break;
            }
        } else if (this.definedTableWidth > 0 && this.tableWidth < this.definedTableWidth) {
            delta = this.definedTableWidth - this.tableWidth;
            int d = delta / this.header.size();
            for (int i = 0; i < this.header.size(); ++i) {
                Column h2 = this.header.get(i);
                h2.width = h2.width + d;
                this.tableWidth += d;
            }
            if (this.tableWidth < this.definedTableWidth) {
                delta = this.definedTableWidth - this.tableWidth;
                Column h4 = this.header.get(this.header.size() - 1);
                h4.width = h4.width + delta;
                this.tableWidth += delta;
            }
        }
    }

    public int getMaxColSize() {
        return this.maxColSize;
    }

    public void setMaxColSize(int maxColSize) {
        this.maxColSize = maxColSize;
    }

    public boolean isLineSpacer() {
        return this.lineSpacer;
    }

    public void setLineSpacer(boolean lineSpacer) {
        this.lineSpacer = lineSpacer;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter ps = new PrintWriter(sw);
        this.print(ps);
        return sw.toString();
    }

    public static ConsoleTable fromJdbcResult(ResultSet res) throws SQLException {
        ResultSetMetaData resMeta = res.getMetaData();
        ConsoleTable out = new ConsoleTable();
        String[] h = new String[resMeta.getColumnCount()];
        for (int i = 0; i < resMeta.getColumnCount(); ++i) {
            h[i] = resMeta.getColumnName(i + 1);
        }
        out.setHeaderValues(h);
        while (res.next()) {
            List<String[]> r = out.addIntRow();
            for (int i = 0; i < resMeta.getColumnCount(); ++i) {
                r.add(String.valueOf(res.getObject(i + 1)).split("\n"));
            }
        }
        return out;
    }

    public String[] toStringArray(boolean showHeader) {
        int i = showHeader ? 1 : 0;
        this.updateHeaderSizes();
        String[] out = new String[this.content.size() + i];
        if (showHeader) {
            out[0] = this.getHeaderRow();
        }
        for (List<String[]> row : this.content) {
            int rowHeight = this.getRowHeight(row);
            for (int l = 0; l < rowHeight; ++l) {
                out[i] = this.getRow(row, l);
            }
            ++i;
        }
        return out;
    }

    public String[][] toStringMatrix(boolean showHeader) {
        int i = showHeader ? 1 : 0;
        String[][] out = new String[this.content.size() + i][];
        if (showHeader) {
            out[0] = this.getHeaderRowArray();
        }
        for (List<String[]> row : this.content) {
            int rowHeight = this.getRowHeight(row);
            for (int l = 0; l < rowHeight; ++l) {
                out[i] = this.getRowArray(row, l);
            }
            ++i;
        }
        return out;
    }

    private String[] getRowArray(List<String[]> row, int line) {
        String[] out = new String[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            out[i] = this.getCellLine(row.get(i), line);
        }
        return out;
    }

    private String[] getHeaderRowArray() {
        String[] out = new String[this.header.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.header.get((int)i).title;
        }
        return out;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public String getColSeparator() {
        return this.colSeparator;
    }

    public void setColSeparator(String colSeparator) {
        this.colSeparator = colSeparator;
    }

    public boolean isAcceptHorizontalLine() {
        return this.acceptHorizontalLine;
    }

    public void setAcceptHorizontalLine(boolean acceptHorizontalLine) {
        this.acceptHorizontalLine = acceptHorizontalLine;
    }

    public boolean isCellSpacer() {
        return this.cellSpacer;
    }

    public void setCellSpacer(boolean cellSpacer) {
        this.cellSpacer = cellSpacer;
    }

    public Column getColumn(int index) {
        return this.header.get(index);
    }

    public int size() {
        return this.content.size();
    }

    public void removeFirstRow() {
        if (this.content.size() == 0) {
            return;
        }
        this.content.remove(0);
    }

    public int getMaxTableWidth() {
        return this.maxTableWidth;
    }

    public void setMaxTableWidth(int maxTableWidth) {
        this.maxTableWidth = maxTableWidth;
    }

    public void addHeader(String name) {
        this.header.add(new Column(name));
    }

    public void fitToConsole() {
        Console console = Console.get();
        if (!console.isSupportSize()) {
            this.setMaxColSize(0);
            return;
        }
        int w = console.getWidth();
        this.setTableWidth(Math.max(w, 80));
    }

    public void setTableWidth(int width) {
        this.definedTableWidth = width;
        this.maxTableWidth = width;
    }

    public void sort(final int col, final Comparator<String> comparator) {
        this.content.sort(new Comparator<List<String[]>>(){

            @Override
            public int compare(List<String[]> o1, List<String[]> o2) {
                String[] a1 = o1.get(col);
                String[] a2 = o2.get(col);
                String l1 = MString.join(a1, '\n');
                String l2 = MString.join(a2, '\n');
                return comparator.compare(l1, l2);
            }
        });
    }

    public class Column {
        private boolean last = false;
        private int width = 0;
        public String title;
        public int minWidth = 0;
        public int maxWidth = 0;
        public int contentWidth = 0;
        public int weight = 0;

        public Column(String title) {
            this.title = title;
        }
    }

    public class Row {
        private List<String[]> row;

        public Row(List<String[]> row) {
            this.row = row;
        }

        public void add(Object v) {
            this.row.add(ConsoleTable.this.splitInLines(v));
        }
    }
}

