/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.base.service;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.base.service.LockManager;
import de.mhus.lib.core.concurrent.Lock;
import de.mhus.lib.core.util.SoftHashMap;
import de.mhus.lib.core.util.WeakList;
import java.util.HashMap;
import java.util.LinkedList;

public class LockManagerImpl
extends MLog
implements LockManager {
    private HashMap<String, Lock> locks = new HashMap();
    private SoftHashMap<String, Lock> cache = new SoftHashMap();
    private WeakList<Lock> register = new WeakList();

    public LockManagerImpl() {
        this.log().i("Start DefaultLockManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getLock(String name) {
        Lock lock = null;
        SoftHashMap<String, Lock> softHashMap = this.cache;
        synchronized (softHashMap) {
            lock = this.cache.get(name);
            if (lock == null) {
                lock = new ManagedLock(name, false);
                this.cache.put(name, lock);
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock[] managedLocks() {
        SoftHashMap<String, Lock> softHashMap = this.cache;
        synchronized (softHashMap) {
            LinkedList<Lock> list = new LinkedList<Lock>();
            for (Lock item : this.cache.values()) {
                if (item == null) continue;
                list.add(item);
            }
            return list.toArray(new Lock[list.size()]);
        }
    }

    @Override
    public void register(Lock lock) {
        this.register.add(lock);
    }

    @Override
    public Lock[] getRegisteredLocks() {
        return this.register.toArray(new Lock[this.register.size()]);
    }

    class ManagerLock
    extends Lock {
        ManagerLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void lockEvent(boolean locked) {
            SoftHashMap softHashMap = LockManagerImpl.this.cache;
            synchronized (softHashMap) {
                if (locked) {
                    LockManagerImpl.this.locks.put(this.name, this);
                    if (!LockManagerImpl.this.cache.containsKey(this.name)) {
                        LockManagerImpl.this.cache.put(this.name, this);
                    }
                } else {
                    LockManagerImpl.this.locks.remove(this.name);
                }
            }
        }
    }

    class ManagedLock
    extends Lock {
        public ManagedLock(String name, boolean b) {
            super(name, b);
        }

        @Override
        protected void register() {
        }
    }
}

