/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging;

import de.mhus.lib.core.config.XmlConfig;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.LogEngine;
import de.mhus.lib.core.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Element;

public final class Log4JFactory
extends LogFactory {
    private static final boolean is12 = Priority.class.isAssignableFrom(Level.class);
    private static final String FQCN = Log4JFactory.class.getName();

    @Override
    public void init(ResourceNode<?> config) throws Exception {
        if (config == null) {
            return;
        }
        Object ccc = config.getNode("configuration");
        String configFile = config.getExtracted("configuration");
        if (ccc != null && ccc instanceof XmlConfig) {
            DOMConfigurator.configure((Element)((XmlConfig)ccc).getXmlElement());
        } else if (configFile != null) {
            if (configFile.endsWith(".properties")) {
                PropertyConfigurator.configureAndWatch((String)configFile);
            } else if (configFile.endsWith(".xml")) {
                DOMConfigurator.configureAndWatch((String)configFile);
            }
        }
    }

    @Override
    public LogEngine createInstance(String name) {
        Log4JLog instance = new Log4JLog(Logger.getLogger((String)name));
        return instance;
    }

    public class Log4JLog
    extends LogEngine {
        private Logger logger;

        private Log4JLog(Logger logger) {
            super(logger.getName());
            this.logger = logger;
        }

        @Override
        public void trace(Object message) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.TRACE, message, null);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.TRACE, message, null);
            }
        }

        @Override
        public void trace(Object message, Throwable t) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.TRACE, message, t);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.TRACE, message, t);
            }
        }

        @Override
        public void debug(Object message) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
            }
        }

        @Override
        public void debug(Object message, Throwable t) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
            }
        }

        @Override
        public void info(Object message) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
            }
        }

        @Override
        public void info(Object message, Throwable t) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
            }
        }

        @Override
        public void warn(Object message) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
            }
        }

        @Override
        public void warn(Object message, Throwable t) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
            }
        }

        @Override
        public void error(Object message) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
            }
        }

        @Override
        public void error(Object message, Throwable t) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
            }
        }

        @Override
        public void fatal(Object message) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
            }
        }

        @Override
        public void fatal(Object message, Throwable t) {
            if (is12) {
                this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
            } else {
                this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
            }
        }

        public Logger getLogger() {
            if (this.logger == null) {
                this.logger = Logger.getLogger((String)this.getName());
            }
            return this.logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.getLogger().isDebugEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            if (is12) {
                return this.getLogger().isEnabledFor((Priority)Level.ERROR);
            }
            return this.getLogger().isEnabledFor((Priority)Level.ERROR);
        }

        @Override
        public boolean isFatalEnabled() {
            if (is12) {
                return this.getLogger().isEnabledFor((Priority)Level.FATAL);
            }
            return this.getLogger().isEnabledFor((Priority)Level.FATAL);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.getLogger().isInfoEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.getLogger().isDebugEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            if (is12) {
                return this.getLogger().isEnabledFor((Priority)Level.WARN);
            }
            return this.getLogger().isEnabledFor((Priority)Level.WARN);
        }

        @Override
        public void doInitialize(LogFactory logFactory) {
        }

        @Override
        public void close() {
        }
    }
}

