/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.definition.DefRoot;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsBundle;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ActionHandler;
import de.mhus.lib.form.ComponentAdapterProvider;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.FormControl;
import de.mhus.lib.form.IUiBuilder;
import de.mhus.lib.form.UiInformation;
import java.util.Locale;

public class MForm
extends MObject
implements MNlsProvider {
    protected Locale locale = Locale.getDefault();
    protected ComponentAdapterProvider adapterProvider;
    protected IConfig model;
    protected DataSource dataSource;
    protected ActionHandler actionHandler;
    protected MNlsBundle nlsBundle;
    protected FormControl control;
    protected UiInformation informationPane;
    protected IUiBuilder builder;

    public MForm() {
    }

    public MForm(Locale locale, ComponentAdapterProvider adapterProvider, IConfig model) {
        if (locale != null) {
            this.locale = locale;
        }
        this.adapterProvider = adapterProvider;
        if (model == null) {
            new NullPointerException("model could not be null");
        }
        this.model = model;
    }

    public MForm(DefRoot model) throws MException {
        this.model = model;
        model.build();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ComponentAdapterProvider getAdapterProvider() {
        return this.adapterProvider;
    }

    public IConfig getModel() {
        return this.model;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = MApi.lookup(DataSource.class);
        }
        return this.dataSource;
    }

    @Override
    public synchronized MNls getNls() {
        if (this.nlsBundle == null) {
            return null;
        }
        return this.nlsBundle.getNls(this.locale);
    }

    public FormControl getControl() {
        if (this.control == null) {
            this.control = MApi.lookup(FormControl.class);
        }
        return this.control;
    }

    public UiInformation getInformationPane() {
        return this.informationPane;
    }

    public MNlsBundle getNlsBundle() {
        return this.nlsBundle;
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public IUiBuilder getBuilder() {
        return this.builder;
    }
}

