/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MArgs;
import de.mhus.lib.core.cfg.CfgFile;
import de.mhus.lib.core.console.ConsoleTable;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.core.system.IApi;
import de.mhus.lib.core.vault.FileVaultSource;
import de.mhus.lib.core.vault.FolderVaultSource;
import de.mhus.lib.core.vault.MVault;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.core.vault.VaultPassphrase;
import de.mhus.lib.core.vault.VaultSource;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class MVaultUtil {
    private static CfgFile defaultFile = new CfgFile((Object)MVault.class, "file", MApi.getFile(IApi.SCOPE.ETC, "de.mhus.lib.core.vault.FileVaultSource.dat"));
    private static CfgFile defaultFolder = new CfgFile((Object)MVault.class, "file", MApi.getFile(IApi.SCOPE.DATA, "de.mhus.lib.core.vault.FolderVaultSource"));

    public static MVault loadDefault() {
        MVault vault = MApi.lookup(MVault.class);
        MVaultUtil.checkDefault(vault);
        return vault;
    }

    public static void checkDefault(MVault vault) {
        VaultSource def = vault.getSource("default");
        if (def == null) {
            VaultPassphrase vaultPassphrase = MApi.lookup(VaultPassphrase.class);
            if (((File)defaultFile.value()).exists()) {
                try {
                    def = new FileVaultSource((File)defaultFile.value(), vaultPassphrase.getPassphrase(), "default");
                    vault.registerSource(def);
                }
                catch (IOException e) {
                    MLogUtil.log().d(e);
                }
            } else {
                try {
                    def = new FolderVaultSource((File)defaultFolder.value(), vaultPassphrase.getPassphrase(), "default");
                    vault.registerSource(def);
                }
                catch (IOException e) {
                    MLogUtil.log().w(e);
                }
            }
        }
    }

    public static void main(String[] in) throws IOException {
        String cmd;
        MArgs args = new MArgs(in);
        MVault vault = MVaultUtil.loadDefault();
        VaultSource source = null;
        if (args.contains("file")) {
            String vp = args.getValue("passphrase", "setit", 0);
            File f = new File(args.getValue("file", 0));
            source = new FileVaultSource(f, vp);
            vault.registerSource(source);
        }
        if (source == null) {
            source = vault.getSource("default");
        }
        switch (cmd = args.getValue("", "help", 0)) {
            case "help": {
                System.out.println("Usage: <cmd> <args>");
                System.out.println("list - list all keys");
                break;
            }
            case "list": {
                ConsoleTable out = new ConsoleTable();
                out.setHeaderValues("Source", "Id", "Type", "Description");
                for (String sourceName : vault.getSourceNames()) {
                    source = vault.getSource(sourceName);
                    for (UUID id : source.getEntryIds()) {
                        VaultEntry entry = source.getEntry(id);
                        out.addRowValues(sourceName, id, entry.getType(), entry.getDescription());
                    }
                }
                out.print(System.out);
            }
        }
    }
}

