/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.mail;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.mail.Mail;
import de.mhus.lib.core.mail.MailAttachment;
import de.mhus.lib.core.mail.MailTransport;
import java.io.IOException;
import java.util.Date;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class HtmlMail
extends MLog
implements Mail {
    private String from;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String subject;
    private String html;
    private MailAttachment[] attachments;

    public HtmlMail setFrom(String from) {
        this.from = from;
        return this;
    }

    public HtmlMail setTo(String[] to) {
        this.to = to;
        return this;
    }

    public HtmlMail setCc(String[] cc) {
        this.cc = cc;
        return this;
    }

    public HtmlMail setBcc(String[] bcc) {
        this.bcc = bcc;
        return this;
    }

    public HtmlMail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public HtmlMail setHtml(String html) {
        this.html = html;
        return this;
    }

    public HtmlMail setAttachments(MailAttachment[] attachments) {
        this.attachments = attachments;
        return this;
    }

    @Override
    public void send(MailTransport transport) throws Exception {
        InternetAddress[] toAddresses = new InternetAddress[this.to.length];
        for (int i = 0; i < this.to.length; ++i) {
            toAddresses[i] = new InternetAddress(this.to[i]);
        }
        InternetAddress[] ccAddresses = null;
        if (this.cc != null && this.cc.length > 0 && this.cc[0] != null) {
            ccAddresses = new InternetAddress[this.cc.length];
            for (int i = 0; i < this.cc.length; ++i) {
                ccAddresses[i] = new InternetAddress(this.cc[i]);
            }
        }
        InternetAddress[] bccAddresses = null;
        if (this.bcc != null && this.bcc.length > 0 && this.bcc[0] != null) {
            bccAddresses = new InternetAddress[this.bcc.length];
            for (int i = 0; i < this.bcc.length; ++i) {
                bccAddresses[i] = new InternetAddress(this.bcc[i]);
            }
        }
        MimeMessage msg = new MimeMessage(transport.getSession());
        msg.setFrom((Address)(MString.isSet(this.from) ? new InternetAddress(this.from) : transport.getFrom()));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        if (ccAddresses != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        if (bccAddresses != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        msg.setSubject(this.subject, "UTF-8");
        msg.setSentDate(new Date());
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setHeader("Content-Type", "text/plain; charset=\"utf-8\"");
        messageBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
        messageBodyPart.setContent((Object)this.html, "text/html; charset=utf-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (this.attachments != null) {
            for (MailAttachment attachment : this.attachments) {
                if (!attachment.getFile().exists() || !attachment.getFile().isFile()) continue;
                MimeBodyPart attachPart = new MimeBodyPart();
                try {
                    attachPart.setFileName(attachment.getName());
                    attachPart.attachFile(attachment.getFile());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                multipart.addBodyPart((BodyPart)attachPart);
            }
        }
        msg.setContent((Multipart)multipart);
        this.log().t(this.html);
        transport.send(msg);
        transport.cleanup(this.attachments);
    }

    public String toString() {
        return MSystem.toString(this, this.subject, "from", this.from, "to", this.to, "cc", this.cc, "bcc", this.bcc, "attachments", this.attachments);
    }
}

