/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.mail;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.MBouncy;
import de.mhus.lib.core.mail.Mail;
import de.mhus.lib.core.mail.MailTransport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class GpgSignedMail
implements Mail {
    static int serialNo = 1;
    private String from;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String subject;
    private String content;
    private String signDN;
    private X509Certificate origCert;
    private KeyPair origKP;
    private CertStore certsAndcrls;

    public GpgSignedMail setFrom(String from) {
        this.from = from;
        return this;
    }

    public GpgSignedMail setTo(String[] to) {
        this.to = to;
        return this;
    }

    public GpgSignedMail setCc(String[] cc) {
        this.cc = cc;
        return this;
    }

    public GpgSignedMail setBcc(String[] bcc) {
        this.bcc = bcc;
        return this;
    }

    public GpgSignedMail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public GpgSignedMail setContent(String content) {
        this.content = content;
        return this;
    }

    public GpgSignedMail createCertificates(String signDN, String origDN) throws Exception {
        this.signDN = signDN;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(1024, new SecureRandom());
        KeyPair signKP = kpg.generateKeyPair();
        X509Certificate signCert = GpgSignedMail.makeCertificate(signKP, signDN, signKP, signDN);
        this.origKP = kpg.generateKeyPair();
        this.origCert = GpgSignedMail.makeCertificate(this.origKP, origDN, signKP, signDN);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(this.origCert);
        certList.add(signCert);
        this.setCertsAndcrls(CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC"));
        return this;
    }

    @Override
    public void send(MailTransport transport) throws Exception {
        MBouncy.init();
        InternetAddress[] toAddresses = new InternetAddress[this.to.length];
        for (int i = 0; i < this.to.length; ++i) {
            toAddresses[i] = new InternetAddress(this.to[i]);
        }
        InternetAddress[] ccAddresses = null;
        if (this.cc != null && this.cc.length > 0) {
            ccAddresses = new InternetAddress[this.cc.length];
            for (int i = 0; i < this.cc.length; ++i) {
                ccAddresses[i] = new InternetAddress(this.cc[i]);
            }
        }
        InternetAddress[] bccAddresses = null;
        if (this.bcc != null && this.bcc.length > 0) {
            bccAddresses = new InternetAddress[this.bcc.length];
            for (int i = 0; i < this.bcc.length; ++i) {
                bccAddresses[i] = new InternetAddress(this.bcc[i]);
            }
        }
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
        IssuerAndSerialNumber issAndSer = new IssuerAndSerialNumber(new X509Name(this.signDN), this.origCert.getSerialNumber());
        signedAttrs.add((DEREncodable)new SMIMEEncryptionKeyPreferenceAttribute(issAndSer));
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSigner(this.origKP.getPrivate(), this.origCert, SMIMESignedGenerator.DIGEST_SHA1, new AttributeTable(signedAttrs), null);
        gen.addCertificatesAndCRLs(this.getCertsAndcrls());
        MimeBodyPart msg = new MimeBodyPart();
        msg.setText(this.content);
        MimeMultipart mm = gen.generate(msg, "BC");
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage body = new MimeMessage(session);
        body.setFrom((Address)(MString.isSet(this.from) ? new InternetAddress(this.from) : transport.getFrom()));
        body.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        if (ccAddresses != null) {
            body.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        if (bccAddresses != null) {
            body.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        body.setSubject(this.subject);
        body.setContent((Object)mm, mm.getContentType());
        body.saveChanges();
        transport.send(body);
    }

    static X509Certificate makeCertificate(KeyPair subKP, String subDN, KeyPair issKP, String issDN) throws GeneralSecurityException, IOException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        v3CertGen.setSerialNumber(BigInteger.valueOf(serialNo++));
        v3CertGen.setIssuerDN(new X509Name(issDN));
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis()));
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 8640000000L));
        v3CertGen.setSubjectDN(new X509Name(subDN));
        v3CertGen.setPublicKey(subPub);
        v3CertGen.setSignatureAlgorithm("MD5WithRSAEncryption");
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)GpgSignedMail.createSubjectKeyId(subPub));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)GpgSignedMail.createAuthorityKeyId(issPub));
        return v3CertGen.generateX509Certificate(issPriv);
    }

    static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey pub) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(pub.getEncoded());
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream((InputStream)bIn).readObject());
        return new AuthorityKeyIdentifier(info);
    }

    static SubjectKeyIdentifier createSubjectKeyId(PublicKey pub) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(pub.getEncoded());
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream((InputStream)bIn).readObject());
        return new SubjectKeyIdentifier(info);
    }

    public KeyPair getOrigKP() {
        return this.origKP;
    }

    public GpgSignedMail setOrigKP(KeyPair origKP) {
        this.origKP = origKP;
        return this;
    }

    public String getSignDN() {
        return this.signDN;
    }

    public void setSignDN(String signDN) {
        this.signDN = signDN;
    }

    public X509Certificate getOrigCert() {
        return this.origCert;
    }

    public void setOrigCert(X509Certificate origCert) {
        this.origCert = origCert;
    }

    public CertStore getCertsAndcrls() {
        return this.certsAndcrls;
    }

    public void setCertsAndcrls(CertStore certsAndcrls) {
        this.certsAndcrls = certsAndcrls;
    }
}

