/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.mail;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.crypt.MBouncy;
import de.mhus.lib.core.mail.Mail;
import de.mhus.lib.core.mail.MailTransport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;

public class GpgEncryptedMail
implements Mail {
    private String from;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String subject;
    private String content;
    private KeyStore ks;

    public GpgEncryptedMail setFrom(String from) {
        this.from = from;
        return this;
    }

    public GpgEncryptedMail setTo(String[] to) {
        this.to = to;
        return this;
    }

    public GpgEncryptedMail setCc(String[] cc) {
        this.cc = cc;
        return this;
    }

    public GpgEncryptedMail setBcc(String[] bcc) {
        this.bcc = bcc;
        return this;
    }

    public GpgEncryptedMail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public GpgEncryptedMail setContent(String content) {
        this.content = content;
        return this;
    }

    public GpgEncryptedMail setKeyStore(KeyStore ks) {
        this.ks = ks;
        return this;
    }

    public GpgEncryptedMail openKeyStore(File file, String passphrase) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, NoSuchProviderException {
        this.ks = KeyStore.getInstance("PKCS12", "BC");
        this.ks.load(new FileInputStream(file), passphrase.toCharArray());
        return this;
    }

    @Override
    public void send(MailTransport transport) throws Exception {
        MBouncy.init();
        InternetAddress[] toAddresses = new InternetAddress[this.to.length];
        for (int i = 0; i < this.to.length; ++i) {
            toAddresses[i] = new InternetAddress(this.to[i]);
        }
        InternetAddress[] ccAddresses = null;
        if (this.cc != null && this.cc.length > 0) {
            ccAddresses = new InternetAddress[this.cc.length];
            for (int i = 0; i < this.cc.length; ++i) {
                ccAddresses[i] = new InternetAddress(this.cc[i]);
            }
        }
        InternetAddress[] bccAddresses = null;
        if (this.bcc != null && this.bcc.length > 0) {
            bccAddresses = new InternetAddress[this.bcc.length];
            for (int i = 0; i < this.bcc.length; ++i) {
                bccAddresses[i] = new InternetAddress(this.bcc[i]);
            }
        }
        Enumeration<String> e = this.ks.aliases();
        String keyAlias = null;
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (!this.ks.isKeyEntry(alias)) continue;
            keyAlias = alias;
        }
        if (keyAlias == null) {
            System.err.println("can't find a private key!");
            System.exit(0);
        }
        Certificate[] chain = this.ks.getCertificateChain(keyAlias);
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        gen.addKeyTransRecipient((X509Certificate)chain[0]);
        MimeBodyPart msg = new MimeBodyPart();
        msg.setText(this.content);
        MimeBodyPart mp = gen.generate(msg, SMIMEEnvelopedGenerator.RC2_CBC, "BC");
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage body = new MimeMessage(session);
        body.setFrom((Address)(MString.isSet(this.from) ? new InternetAddress(this.from) : transport.getFrom()));
        body.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        if (ccAddresses != null) {
            body.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        if (bccAddresses != null) {
            body.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        body.setSubject(this.subject, "UTF-8");
        body.setContent(mp.getContent(), mp.getContentType());
        body.saveChanges();
        transport.send(body);
    }
}

