/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.mail;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MPassword;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MTimeInterval;
import de.mhus.lib.core.cfg.CfgBoolean;
import de.mhus.lib.core.cfg.CfgLong;
import de.mhus.lib.core.cfg.CfgString;
import de.mhus.lib.core.mail.MSendMail;
import de.mhus.lib.core.mail.Mail;
import de.mhus.lib.core.mail.MailAttachment;
import de.mhus.lib.core.mail.MailTransport;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class DefaultSendMail
extends MLog
implements MSendMail {
    private static CfgString CFG_MAIL_USER = new CfgString((Object)MSendMail.class, "user", "");
    private static CfgString CFG_MAIL_PASSWORD = new CfgString((Object)MSendMail.class, "password", "");
    private static CfgString CFG_HOST = new CfgString((Object)MSendMail.class, "host", "localhost");
    private static CfgString CFG_PORT = new CfgString((Object)MSendMail.class, "port", "587");
    private static CfgBoolean CFG_TLS = new CfgBoolean((Object)MSendMail.class, "tls", true);
    private static CfgString CFG_FROM = new CfgString((Object)MSendMail.class, "from", "");
    private static CfgLong CFG_CONNECTION_TIMEOUT = new CfgLong((Object)MSendMail.class, "connection.timeout", 60000L);
    private Transport transport;
    private long lastMailTransport;
    private Session session;
    private DefaultMailTransport mailTransport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() throws MessagingException {
        DefaultSendMail defaultSendMail = this;
        synchronized (defaultSendMail) {
            if (this.transport != null && (MTimeInterval.isTimeOut(this.lastMailTransport, (Long)CFG_CONNECTION_TIMEOUT.value()) || !this.transport.isConnected())) {
                this.reset();
            }
            if (this.session == null || this.transport == null) {
                final Properties properties = new Properties();
                properties.put("mail.transport.protocol", "smtp");
                properties.put("mail.smtp.host", CFG_HOST.value());
                properties.put("mail.smtp.port", CFG_PORT.value());
                if (MString.isSet((String)CFG_MAIL_USER.value())) {
                    properties.put("mail.smtp.auth", "true");
                    properties.put("mail.user", CFG_MAIL_USER.value());
                    properties.put("mail.password", MPassword.decode((String)CFG_MAIL_PASSWORD.value()));
                }
                if (((Boolean)CFG_TLS.value()).booleanValue()) {
                    properties.put("mail.smtp.starttls.enable", (Object)true);
                    properties.put("mail.smtp.ssl.trust", CFG_HOST.value());
                }
                Authenticator auth = null;
                if (MString.isSet((String)CFG_MAIL_USER.value())) {
                    auth = new Authenticator(){

                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(properties.getProperty("mail.user"), properties.getProperty("mail.password"));
                        }
                    };
                }
                this.session = Session.getInstance((Properties)properties, auth);
                this.transport = this.session.getTransport();
                this.transport.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DefaultSendMail defaultSendMail = this;
        synchronized (defaultSendMail) {
            if (this.transport != null) {
                try {
                    this.transport.close();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
            }
            this.transport = null;
            this.session = null;
            this.lastMailTransport = 0L;
        }
    }

    @Override
    public void sendMail(Mail mail) throws Exception {
        this.log().d("mail", mail);
        mail.send(this.getMailTransport());
    }

    @Override
    public MailTransport getMailTransport() throws Exception {
        if (this.mailTransport == null) {
            this.mailTransport = new DefaultMailTransport();
        }
        return this.mailTransport;
    }

    private class DefaultMailTransport
    implements MailTransport {
        private DefaultMailTransport() {
        }

        @Override
        public Session getSession() throws Exception {
            DefaultSendMail.this.connect();
            return DefaultSendMail.this.session;
        }

        @Override
        public Address getFrom() throws AddressException {
            return new InternetAddress((String)CFG_FROM.value());
        }

        @Override
        public void send(MimeMessage msg) throws Exception {
            DefaultSendMail.this.connect();
            Transport.send((Message)msg);
        }

        @Override
        public void cleanup(MailAttachment[] attachments) {
            if (attachments != null) {
                for (MailAttachment attachment : attachments) {
                    if (attachment == null || !attachment.isDeleteAfterSent()) continue;
                    try {
                        attachment.getFile().delete();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public String getConnectInfo() {
            return ((Boolean)CFG_TLS.value() != false ? "tls:" : "smtp:") + "//" + (MString.isSet((String)CFG_MAIL_USER.value()) ? (String)CFG_MAIL_USER.value() + "@" : "") + (String)CFG_HOST.value() + ":" + (String)CFG_PORT.value();
        }
    }
}

