/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt.pem;

import de.mhus.lib.core.crypt.pem.PemBlock;
import de.mhus.lib.core.crypt.pem.PemBlockModel;
import de.mhus.lib.core.crypt.pem.PemPriv;
import de.mhus.lib.core.crypt.pem.PemPub;
import de.mhus.lib.errors.MException;
import java.util.Map;

public class PemKey
extends PemBlockModel
implements PemPriv,
PemPub {
    private boolean secret;

    public PemKey(PemKey clone, boolean secret) {
        super(clone.getName(), clone.getBlock());
        for (Map.Entry<String, Object> entry : clone) {
            this.put(entry.getKey(), entry.getValue());
        }
        this.secret = secret;
    }

    public PemKey(String name, byte[] block, boolean secret) {
        super(name, block);
        this.secret = secret;
    }

    public PemKey(String name, String block, boolean secret) {
        super(name, block);
        this.secret = secret;
    }

    public PemKey() {
    }

    public PemKey(PemBlock clone) {
        super(clone);
    }

    public PemKey(String name) {
        super(name);
    }

    @Override
    public String getMethod() throws MException {
        return this.getString("Method");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN ").append(this.getName()).append("-----\n");
        for (Map.Entry<String, Object> item : this.entrySet()) {
            sb.append(item.getKey()).append(": ").append(item.getValue()).append('\n');
        }
        sb.append('\n');
        if (this.secret) {
            sb.append("?");
        } else {
            sb.append(this.getEncodedBlock());
        }
        sb.append("\n\n");
        sb.append("-----END ").append(this.getName()).append("-----\n");
        return sb.toString();
    }
}

