/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt.pem;

import de.mhus.lib.core.crypt.pem.PemBlock;
import de.mhus.lib.core.crypt.pem.PemBlockModel;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.core.parser.ParseException;
import java.util.LinkedList;

public class PemBlockList
extends LinkedList<PemBlock> {
    private static final long serialVersionUID = 1L;

    public PemBlockList() {
    }

    public PemBlockList(String string) {
        try {
            int p;
            while ((p = string.indexOf("-----BEGIN ")) >= 0) {
                PemBlockModel next = new PemBlockModel().parse(string);
                this.add(next);
                string = next.getRest();
            }
        }
        catch (ParseException e) {
            MLogUtil.log().t(new Object[]{e});
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (PemBlock block : this) {
            b.append(block);
        }
        return b.toString();
    }

    public String toString(int offset, int len) {
        StringBuilder b = new StringBuilder();
        int cnt = 0;
        for (PemBlock block : this) {
            if (cnt >= offset + len) break;
            if (cnt >= offset) {
                b.append(block);
            }
            ++cnt;
        }
        return b.toString();
    }

    public PemBlock find(String name) {
        for (PemBlock block : this) {
            if (!name.equals(block.getName())) continue;
            return block;
        }
        return null;
    }
}

