/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.directory.WritableResourceNode;
import de.mhus.lib.errors.MException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

public class JsonConfig
extends IConfig {
    private static final long serialVersionUID = 1L;
    private ObjectNode node;
    protected String name;
    private WritableResourceNode<IConfig> parent;

    public JsonConfig(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode nodex = (JsonNode)mapper.readValue(json, JsonNode.class);
        if (nodex instanceof ObjectNode) {
            this.node = (ObjectNode)nodex;
        } else {
            this.node = ((ArrayNode)nodex).objectNode();
            this.node.put("default", nodex);
        }
    }

    public JsonConfig(ObjectNode node) {
        this(null, null, (JsonNode)node);
    }

    public JsonConfig(String name, IConfig parent, JsonNode node) {
        if (node instanceof ObjectNode) {
            this.node = (ObjectNode)node;
        } else if (node instanceof ArrayNode) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.node = (ObjectNode)mapper.readValue("{}", JsonNode.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.node.put("array", node);
        } else {
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.node = (ObjectNode)mapper.readValue("{}", JsonNode.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.node.put("value", node);
        }
        this.name = name;
        this.parent = parent;
    }

    public JsonConfig() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        this.node = (ObjectNode)mapper.readValue("{}", JsonNode.class);
    }

    public JsonConfig(String name, JsonConfig jsonConfig, TextNode textNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        this.node = (ObjectNode)mapper.readValue("{}", JsonNode.class);
        this.node.put("value", (JsonNode)textNode);
        this.name = name;
    }

    @Override
    public IConfig getNode(String name) {
        JsonNode child = this.node.get(name);
        if (child == null) {
            return null;
        }
        if (child.isObject() || child.isArray()) {
            return new JsonConfig(name, (IConfig)this, child);
        }
        return null;
    }

    @Override
    public List<IConfig> getNodes(String name) {
        JsonNode child = this.node.get(name);
        if (child == null || !child.isArray()) {
            return MCollection.getEmptyList();
        }
        LinkedList<IConfig> out = new LinkedList<IConfig>();
        for (int i = 0; i < child.size(); ++i) {
            out.add(new JsonConfig(name, (IConfig)this, child.get(i)));
        }
        return out;
    }

    @Override
    public List<IConfig> getNodes() {
        LinkedList<IConfig> out = new LinkedList<IConfig>();
        for (JsonNode child : this.node) {
            if (child != null && child.isArray()) {
                for (int i = 0; i < child.size(); ++i) {
                    out.add(new JsonConfig(this.name, (IConfig)this, child.get(i)));
                }
                continue;
            }
            if (child == null || !child.isObject()) continue;
            out.add(new JsonConfig(this.name, (IConfig)this, child));
        }
        return out;
    }

    public List<String> getNodeKeys() {
        LinkedList<String> out = new LinkedList<String>();
        Iterator i = this.node.getFieldNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            JsonNode child = this.node.get(name);
            if (!child.isArray() && !child.isObject()) continue;
            out.add(name);
        }
        return out;
    }

    @Override
    public Object getProperty(String name) {
        JsonNode child = this.node.get(name);
        if (child == null) {
            return null;
        }
        return child.getValueAsText();
    }

    public List<String> getPropertyKeys() {
        LinkedList<String> out = new LinkedList<String>();
        Iterator i = this.node.getFieldNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            JsonNode child = this.node.get(name);
            if (child.isArray() || child.isObject()) continue;
            out.add(name);
        }
        return out;
    }

    @Override
    public boolean isProperty(String name) {
        JsonNode child = this.node.get(name);
        return child != null && !child.isArray() && !child.isObject();
    }

    @Override
    public void removeProperty(String name) {
        JsonNode child = this.node.get(name);
        if (child != null && !child.isArray() && !child.isObject()) {
            this.getNode().remove(name);
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        JsonNode child = this.node.get(name);
        if (child == null || !child.isArray() && !child.isObject()) {
            this.getNode().put(name, MCast.objectToString(value));
        }
    }

    public ObjectNode getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WritableResourceNode<IConfig> createConfig(String key) throws MException {
        ArrayNode array;
        if (this.node.get(key) != null && !this.node.get(key).isArray()) {
            this.node.remove(key);
        }
        if ((array = (ArrayNode)this.node.get(key)) == null) {
            array = this.node.arrayNode();
            this.node.put(key, (JsonNode)array);
        }
        if (!(array instanceof ArrayNode)) {
            throw new MException(new Object[]{key + " is not an array"});
        }
        ObjectNode out = array.objectNode();
        array.add((JsonNode)out);
        return new JsonConfig(key, (IConfig)this, (JsonNode)out);
    }

    @Override
    public int moveConfig(IConfig config, int newPos) throws MException {
        if (!(config instanceof JsonConfig)) {
            throw new MException(new Object[]{"not JsonConfig"});
        }
        JsonNode array = this.node.get(config.getName());
        if (array == null) {
            throw new MException(new Object[]{"config set not found"});
        }
        int pos = this.findPosOf((ArrayNode)array, (JsonConfig)config);
        if (pos < 0) {
            throw new MException(new Object[]{"could not find child"});
        }
        if (((ArrayNode)array).size() == 1) {
            if (newPos == -102 || newPos == -103 || newPos == 0) {
                return 0;
            }
            throw new MException(new Object[]{"out of range"});
        }
        if (newPos == -102) {
            ((ArrayNode)array).remove(pos);
            ((ArrayNode)array).insert(0, (JsonNode)((JsonConfig)config).node);
            return 0;
        }
        if (newPos == -103) {
            ((ArrayNode)array).remove(pos);
            ((ArrayNode)array).add((JsonNode)((JsonConfig)config).node);
            return ((ArrayNode)array).size() - 1;
        }
        if (newPos == -101) {
            if (pos == ((ArrayNode)array).size() - 1) {
                throw new MException(new Object[]{"out of range"});
            }
            ((ArrayNode)array).remove(pos);
            ((ArrayNode)array).insert(pos + 1, (JsonNode)((JsonConfig)config).node);
            return pos + 1;
        }
        if (newPos == -100) {
            if (pos == 0) {
                throw new MException(new Object[]{"out of range"});
            }
            ((ArrayNode)array).remove(pos);
            ((ArrayNode)array).insert(pos - 1, (JsonNode)((JsonConfig)config).node);
            return pos - 1;
        }
        if (pos == newPos) {
            return pos;
        }
        ((ArrayNode)array).remove(pos);
        ((ArrayNode)array).insert(newPos, (JsonNode)((JsonConfig)config).node);
        return newPos;
    }

    @Override
    public void removeConfig(IConfig config) throws MException {
        if (!(config instanceof JsonConfig)) {
            return;
        }
        JsonNode array = this.node.get(config.getName());
        if (array == null) {
            return;
        }
        int pos = this.findPosOf((ArrayNode)array, (JsonConfig)config);
        if (pos < 0) {
            throw new MException(new Object[]{"could not find child"});
        }
        ((ArrayNode)array).remove(pos);
    }

    protected int findPosOf(ArrayNode array, JsonConfig config) {
        int cnt = 0;
        for (JsonNode item : array) {
            if (item == config.node) {
                return cnt;
            }
            ++cnt;
        }
        return -1;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public WritableResourceNode<IConfig> getParent() {
        return this.parent;
    }

    public void write(OutputStream os) throws IOException {
        ObjectMapper m = new ObjectMapper();
        m.writeValue(os, (Object)this.node);
    }

    public void write(Writer os) throws IOException {
        ObjectMapper m = new ObjectMapper();
        m.writeValue(os, (Object)this.node);
    }

    @Override
    public InputStream getInputStream(String key) {
        return null;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public void clear() {
        this.node.removeAll();
    }
}

