/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.MConfig;
import de.mhus.lib.core.config.PropertiesConfig;
import de.mhus.lib.core.util.EmptyList;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;

public class DirConfig
extends PropertiesConfig {
    private static final long serialVersionUID = 1L;
    private File dir;

    public DirConfig(File dir) {
        this.dir = dir;
        File f = new File(dir, "_.properties");
        if (f.exists() && f.isFile()) {
            try {
                FileReader r = new FileReader(f);
                this.readConfig(r);
                r.close();
            }
            catch (Exception e) {
                this.log().d(dir, e);
            }
        }
    }

    @Override
    public List<String> getPropertyKeys() {
        return new EmptyList<String>();
    }

    @Override
    public IConfig getNode(String key) {
        try {
            String keyDot = key + ".";
            for (File f : this.dir.listFiles()) {
                if ((!f.isDirectory() || !f.getName().equals(key)) && (f.isDirectory() || !f.getName().startsWith(keyDot))) continue;
                return MConfig.createConfigFor(f);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<IConfig> getNodes(String key) {
        LinkedList<IConfig> out = new LinkedList<IConfig>();
        String keyDot = key + ".";
        for (File f : this.dir.listFiles()) {
            try {
                if ((!f.isDirectory() || !f.getName().equals(key)) && (f.isDirectory() || !f.getName().startsWith(keyDot))) continue;
                out.add(MConfig.createConfigFor(f));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return out;
    }

    @Override
    public List<IConfig> getNodes() {
        LinkedList<IConfig> out = new LinkedList<IConfig>();
        for (File f : this.dir.listFiles()) {
            try {
                IConfig conf;
                if (f.isDirectory() && !f.getName().startsWith(".") && !f.isHidden()) {
                    out.add(MConfig.createConfigFor(f));
                    continue;
                }
                if (f.isDirectory() || f.isHidden() || (conf = MConfig.createConfigFor(f)) == null) continue;
                out.add(conf);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return out;
    }

    @Override
    public List<String> getNodeKeys() {
        LinkedList<String> out = new LinkedList<String>();
        for (File f : this.dir.listFiles()) {
            if (f.isDirectory() && !out.contains(f.getName())) {
                out.add(f.getName());
                continue;
            }
            if (f.isDirectory() || f.getName().startsWith("_")) continue;
            String name = f.getName();
            int pos = name.indexOf(46);
            if (pos > 0) {
                name = name.substring(0, pos);
            }
            if (out.contains(name)) continue;
            out.add(name);
        }
        return out;
    }

    @Override
    public String getName() {
        return this.dir.getName();
    }

    @Override
    public IConfig createConfig(String key) throws MException {
        return null;
    }

    @Override
    public int moveConfig(IConfig config, int newPos) throws MException {
        return 0;
    }

    @Override
    public void removeConfig(IConfig config) throws MException {
    }

    @Override
    public IConfig getParent() {
        File parent = this.dir.getParentFile();
        if (parent == null) {
            return null;
        }
        return new DirConfig(parent);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public File getDirectory() {
        return this.dir;
    }
}

