/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.concurrent;

import de.mhus.lib.errors.TimeoutRuntimeException;

public class Lock {
    protected Thread lock = null;
    protected String name;
    protected boolean privacy = false;

    public Lock() {
    }

    public Lock(String name, boolean privacy) {
        this.setName(name);
        this.privacy = privacy;
    }

    public Lock(String name) {
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Lock lock = this;
        synchronized (lock) {
            while (this.isLocked()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.lock = Thread.currentThread();
            this.lockEvent(true);
        }
    }

    protected void lockEvent(boolean locked) {
    }

    public void lockWithException(long timeout) {
        if (this.lock(timeout)) {
            return;
        }
        throw new TimeoutRuntimeException(new Object[]{this.name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(long timeout) {
        Lock lock = this;
        synchronized (lock) {
            while (this.isLocked()) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start < timeout) continue;
                return false;
            }
            this.lock = Thread.currentThread();
            this.lockEvent(true);
            return true;
        }
    }

    public void lock(Runnable task) {
        try {
            this.lock();
            task.run();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Runnable task, long timeout) {
        try {
            this.lockWithException(timeout);
            task.run();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock() {
        Lock lock = this;
        synchronized (lock) {
            if (this.lock != Thread.currentThread()) {
                return false;
            }
            this.lockEvent(false);
            this.lock = null;
            this.notify();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockHard() {
        Lock lock = this;
        synchronized (lock) {
            this.lockEvent(false);
            this.lock = null;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilUnlock() {
        Lock lock = this;
        synchronized (lock) {
            while (this.isLocked()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void waitWithException(long timeout) {
        if (this.waitUntilUnlock(timeout)) {
            return;
        }
        throw new TimeoutRuntimeException(new Object[]{this.name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilUnlock(long timeout) {
        Lock lock = this;
        synchronized (lock) {
            while (this.isLocked()) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start < timeout) continue;
                return false;
            }
            return true;
        }
    }

    public boolean isLocked() {
        return this.lock != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Thread getLocker() {
        if (this.privacy) {
            return null;
        }
        return this.lock;
    }

    public boolean isPrivacy() {
        return this.privacy;
    }

    public String toString() {
        return this.name + (this.lock != null ? " " + this.lock.getName() : "");
    }
}

