/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.base.service;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.base.service.LockManager;
import de.mhus.lib.core.concurrent.Lock;
import de.mhus.lib.core.util.SoftHashMap;
import java.util.HashMap;

public class LockManagerImpl
extends MLog
implements LockManager {
    private HashMap<String, Lock> locks = new HashMap();
    private SoftHashMap<String, Lock> cache = new SoftHashMap();

    public LockManagerImpl() {
        this.log().i("Start DefaultLockManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock getLock(String name) {
        Lock lock = null;
        SoftHashMap<String, Lock> softHashMap = this.cache;
        synchronized (softHashMap) {
            lock = this.cache.get(name);
            if (lock == null) {
                lock = new Lock(name, false);
                this.cache.put(name, lock);
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] currentLocks() {
        SoftHashMap<String, Lock> softHashMap = this.cache;
        synchronized (softHashMap) {
            return this.locks.keySet().toArray(new String[this.locks.size()]);
        }
    }

    class ManagerLock
    extends Lock {
        ManagerLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void lockEvent(boolean locked) {
            SoftHashMap softHashMap = LockManagerImpl.this.cache;
            synchronized (softHashMap) {
                if (locked) {
                    LockManagerImpl.this.locks.put(this.name, this);
                    if (!LockManagerImpl.this.cache.containsKey(this.name)) {
                        LockManagerImpl.this.cache.put(this.name, this);
                    }
                } else {
                    LockManagerImpl.this.locks.remove(this.name);
                }
            }
        }
    }
}

