/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.annotations.jmx.JmxManaged;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MDate;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.core.service.UniqueId;

@JmxManaged(descrition="Simple Counter")
public class MCount
extends MJmx {
    protected long cnt = 0L;
    private String name;
    private long startTime = 0L;
    private long lastTime = 0L;
    protected boolean isClosed;

    public MCount() {
        this.name = "Counter " + MApi.lookup(UniqueId.class).nextUniqueId();
    }

    public MCount(String name) {
        super(true, name);
        this.name = name;
    }

    @JmxManaged(descrition="Reset the counter statistic")
    public void reset() {
        this.isClosed = false;
        this.cnt = 0L;
        this.startTime = 0L;
        this.lastTime = 0L;
    }

    public void inc() {
        if (this.isClosed) {
            return;
        }
        ++this.cnt;
        this.lastTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = this.lastTime;
        }
    }

    @JmxManaged(descrition="Amount of counts")
    public long getValue() {
        return this.cnt;
    }

    public double getHitsPerSecond() {
        if (this.startTime == 0L || this.lastTime == 0L || this.cnt == 0L) {
            return 0.0;
        }
        return (double)this.cnt / (double)((this.lastTime - this.startTime) / 1000L);
    }

    @JmxManaged(descrition="Name of this value")
    public String getName() {
        return this.name;
    }

    public long getFirstHitTime() {
        return this.startTime;
    }

    public long getLastHitTime() {
        return this.lastTime;
    }

    @JmxManaged(descrition="Readable status of the counter")
    public String getStatusAsString() {
        if (this.startTime == 0L || this.lastTime == 0L || this.cnt == 0L) {
            return "unused";
        }
        return MDate.toIsoDateTime(this.getFirstHitTime()) + " - " + MDate.toIsoDateTime(this.getLastHitTime()) + "," + this.getHitsPerSecond() + " hits/sec," + this.cnt;
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.log().i("close", this.name, this.cnt, this.getHitsPerSecond());
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.getStatusAsString());
    }
}

