/**
 * Copyright 2018 Mike Hummel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.system.IApi;

public class MLogUtil {

	private static Log log = null;
	
	public synchronized static Log log() {
		if (log == null) {
			try {
				log = Log.getLog(MLogUtil.class);
			} catch (Throwable t) {
				t.printStackTrace();
			}
		}
		return log;
	}
	
	public static void setTrailConfig() {
		setTrailConfig(null);
	}
	
	public static void setTrailConfig(String parameters) {
		IApi api = MApi.get();
		LevelMapper mapper = api.getLogFactory().getLevelMapper();
		if (mapper != null && mapper instanceof TrailLevelMapper) {
			TrailLevelMapper m = (TrailLevelMapper)mapper;
//			ThreadMapperConfig config = new ThreadMapperConfig();
//			if (parameters != null) {
//				config.doConfigure(parameters);
//			}
			m.doConfigureTrail(parameters);
		}
	}

	public static String getTrailConfig() {
		IApi api = MApi.get();
		LevelMapper mapper = api.getLogFactory().getLevelMapper();
		if (mapper != null && mapper instanceof TrailLevelMapper) {
			TrailLevelMapper m = (TrailLevelMapper)mapper;
			return m.doSerializeTrail();
		}
		return null;
	}

	public static void releaseTrailConfig() {
		IApi api = MApi.get();
		LevelMapper mapper = api.getLogFactory().getLevelMapper();
		if (mapper != null && mapper instanceof TrailLevelMapper) {
			TrailLevelMapper m = (TrailLevelMapper)mapper;
			m.doResetTrail();
		}
	}

	public static void resetAllTrailConfigs() {
		IApi api = MApi.get();
		LevelMapper mapper = api.getLogFactory().getLevelMapper();
		if (mapper != null && mapper instanceof TrailLevelMapper) {
			TrailLevelMapper m = (TrailLevelMapper)mapper;
			m.doResetAllTrails();
		}
	}
	
	public static boolean isTrailLevelMapper() {
		IApi api = MApi.get();
		LevelMapper mapper = api.getLogFactory().getLevelMapper();
		return (mapper != null && mapper instanceof TrailLevelMapper);
	}
	
	public static void logStackTrace(Log log, String prefix, StackTraceElement[] stackTrace) {
		for (StackTraceElement element : stackTrace) {
			log.w(prefix,"  " + element);
		}
		
	}

}
