/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.definition;

import de.mhus.lib.core.definition.IDefAttribute;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.definition.FmElement;
import de.mhus.lib.form.definition.FmNls;

public class FmNumber
extends FmElement {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_NUMBER = "number";
    public static final String ALLOW_NEGATIVE = "allow_negative";
    public static final String MINIMUM = "min";
    public static final String MAXIMUM = "max";
    public static final String FORMAT = "format";
    public static final String NUMBER_TYPE = "number";

    public FmNumber(String name, TYPES type, String title, String description, IDefAttribute ... definitions) {
        this(name, type, new FmNls(title, description));
        this.addDefinition(definitions);
    }

    public FmNumber(String name, TYPES type, IDefAttribute ... definitions) {
        super(name, definitions);
        this.setString("type", "number");
        this.setString("number", type.name().toLowerCase());
    }

    public FmNumber allowNull(boolean in) throws MException {
        this.setBoolean("allow_null", in);
        return this;
    }

    public FmNumber allowNegative(boolean in) throws MException {
        this.setBoolean(ALLOW_NEGATIVE, in);
        return this;
    }

    public FmNumber min(int min) throws MException {
        this.setInt(MINIMUM, min);
        return this;
    }

    public FmNumber max(int max) throws MException {
        this.setInt(MAXIMUM, max);
        return this;
    }

    public FmNumber format(FORMAT format) throws MException {
        this.setString(FORMAT, format.name());
        return this;
    }

    public static enum FORMAT {
        PERCENTAGE,
        CURRENCY;

    }

    public static enum TYPES {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

