/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MValidator;
import de.mhus.lib.core.crypt.MCrypt;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.DefaultEntry;
import de.mhus.lib.core.vault.MutableVaultSource;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.errors.MException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.UUID;

public class FolderVaultSource
extends MutableVaultSource {
    private SecureString passphrase;
    private File folder;

    public FolderVaultSource(File folder, String passphrase, String name) throws IOException {
        this(folder, passphrase);
        this.name = name;
    }

    public FolderVaultSource(File folder, String passphrase) throws IOException {
        this.passphrase = new SecureString(passphrase);
        this.folder = folder;
        if (folder.exists()) {
            this.doLoad();
        } else {
            folder.mkdirs();
        }
    }

    @Override
    public void doLoad() throws IOException {
        File file = new File(this.folder, "info.txt");
        if (file.exists()) {
            this.name = MFile.readFile(file).trim();
        }
        this.entries.clear();
        for (File file2 : this.folder.listFiles()) {
            if (file2.getName().startsWith(".") || !file2.isFile() || !MValidator.isUUID(file2.getName())) continue;
            this.loadEntry(file2);
        }
    }

    protected void loadEntry(File file) throws IOException {
        FileInputStream parent = new FileInputStream(file);
        InputStream is = MCrypt.createCipherInputStream(parent, this.passphrase.value());
        ObjectInputStream ois = new ObjectInputStream(is);
        FileEntry entry = new FileEntry(ois);
        try {
            this.addEntry(entry);
        }
        catch (MException e) {
            this.log().d(new Object[]{entry, e});
        }
        parent.close();
    }

    @Override
    public void doSave() throws IOException {
        File file = new File(this.folder, "info.txt");
        MFile.writeFile(file, this.name);
        HashSet<String> ids = new HashSet<String>();
        for (VaultEntry entry : this.entries.values()) {
            ids.add(entry.getId().toString());
            this.saveEntry(entry);
        }
        for (File file2 : this.folder.listFiles()) {
            if (file2.getName().startsWith(".") || !file2.isFile() || !MValidator.isUUID(file2.getName()) || ids.contains(file2.getName())) continue;
            file2.delete();
        }
    }

    protected void saveEntry(VaultEntry entry) throws IOException {
        File file = new File(this.folder, entry.getId().toString());
        FileOutputStream parent = new FileOutputStream(file);
        OutputStream os = MCrypt.createCipherOutputStream(parent, this.passphrase.value());
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeUTF(entry.getId().toString());
        oos.writeUTF(entry.getType());
        oos.writeUTF(entry.getDescription());
        oos.writeUTF(entry.getValue());
        oos.flush();
        parent.close();
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.name, this.entries.size(), this.folder);
    }

    @Override
    public boolean isMemoryBased() {
        return true;
    }

    private class FileEntry
    extends DefaultEntry {
        public FileEntry(ObjectInputStream ois) throws IOException {
            this.id = UUID.fromString(ois.readUTF());
            this.type = ois.readUTF();
            this.description = ois.readUTF();
            this.value = new SecureString(ois.readUTF());
        }
    }
}

