/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.cfg.CfgString;
import de.mhus.lib.core.io.http.MHttpClientBuilder;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.parser.StringPropertyReplacer;
import de.mhus.lib.errors.UsageException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MMaven {
    private static CfgString CFG_MAVEN_LOCAL_REPO = new CfgString(MMaven.class, "repositoryLocaltion", null);
    private static String repositoryLocation;
    private static Log log;
    private static StringPropertyReplacer replacer;

    public static File locateArtifact(Artifact artifact) {
        MMaven.getLocalRepositoryLocation();
        String artifactLocation = artifact.toLocation();
        return new File(repositoryLocation + '/' + artifactLocation);
    }

    public static List<Element> getConfigElements(String path) {
        Document settings;
        File settingsFile;
        LinkedList<Element> out = new LinkedList<Element>();
        try {
            settingsFile = new File(MSystem.getUserHome() + "/.m2/settings.xml");
            if (settingsFile.exists() && settingsFile.isFile()) {
                settings = MXml.loadXml(settingsFile);
                MXml.getElementsByPath(settings.getDocumentElement(), path, out);
            }
        }
        catch (Throwable t) {
            log.d(t);
        }
        if (MString.isSet(System.getenv("MAVEN_HOME"))) {
            try {
                settingsFile = new File(System.getenv("MAVEN_HOME") + "/conf/settings.xml");
                if (settingsFile.exists() && settingsFile.isFile()) {
                    settings = MXml.loadXml(settingsFile);
                    MXml.getElementsByPath(settings.getDocumentElement(), path, out);
                }
            }
            catch (Throwable t) {
                log.d(t);
            }
        }
        return out;
    }

    public static String getLocalRepositoryLocation() {
        if (repositoryLocation != null) {
            return repositoryLocation;
        }
        repositoryLocation = (String)CFG_MAVEN_LOCAL_REPO.value();
        if (repositoryLocation == null) {
            try {
                List<Element> list = MMaven.getConfigElements("localRepository");
                if (list.size() > 0) {
                    repositoryLocation = MXml.getValue(list.get(0), false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (repositoryLocation == null) {
            repositoryLocation = "${user.home}/.m2/repository";
        }
        if (repositoryLocation != null) {
            repositoryLocation = replacer.process(repositoryLocation);
        }
        return repositoryLocation;
    }

    public static boolean downloadArtefact(Artifact artifact) {
        List<Element> mirrors = MMaven.getConfigElements("mirrors/mirror");
        List<Element> proxies = MMaven.getConfigElements("proxies/proxy");
        List<Element> repos = MMaven.getConfigElements("repositories/repository");
        try {
            Document doc = MXml.loadXml("<repository><id>central</id><name>Central Repository</name><url>http://repo.maven.apache.org/maven2</url></repository>");
            repos.add(doc.getDocumentElement());
        }
        catch (Throwable t) {
            log.e(t);
        }
        boolean isRelease = artifact.isRelease();
        for (Element repo : repos) {
            String url;
            String id = MXml.getValue(repo, "id", "");
            boolean hasReleases = MCast.toboolean(MXml.getValue(repo, "releases/enabled", "true"), false);
            boolean hasStapshots = MCast.toboolean(MXml.getValue(repo, "snapshots/enabled", "true"), false);
            if (isRelease && !hasReleases || !isRelease && !hasStapshots || (url = MXml.getValue(repo, "url", null)) == null) continue;
            String protocol = MString.beforeIndex(url, ':');
            Element useProxy = null;
            Element useMirror = null;
            String useProxyId = null;
            String useMirrorId = null;
            if (!protocol.equals("file")) {
                for (Element mirror : mirrors) {
                    String[] rules = MXml.getValue(mirror, "mirrorOf", "").split(",");
                    boolean ok = false;
                    for (String rule : rules) {
                        ok = rule.startsWith("!") && rule.substring(1).equals(id) ? false : rule.equals("*") || rule.equals("external:*") || rule.equals(id);
                    }
                    if (!ok) continue;
                    useMirror = mirror;
                    useMirrorId = MXml.getValue(useMirror, "id", "");
                    url = MXml.getValue(useMirror, "url", null);
                    protocol = MString.beforeIndex(url, ':');
                    break;
                }
                for (Element proxy : proxies) {
                    if (!MXml.getValue(proxy, "active", "").equals("true") || !protocol.equals(MXml.getValue(proxy, "protocol", ""))) continue;
                    useProxy = proxy;
                    useProxyId = MXml.getValue(useProxy, "host", "");
                    break;
                }
            }
            log.t("try download artifact:", artifact, "source:", id, useProxyId, useMirrorId);
            try {
                MHttpClientBuilder client = new MHttpClientBuilder();
                if (useProxy != null) {
                    client.setProxyHost(MXml.getValue(useProxy, "host", ""));
                    client.setProxyPort(MCast.toint(MXml.getValue(useProxy, "port", "3128"), 3128));
                } else {
                    client.setUseSystemProperties(true);
                }
                String download = url + '/' + artifact.toLocation();
                HttpGet action = new HttpGet(download);
                HttpResponse response = client.execute(action);
                if (response.getStatusLine().getStatusCode() == 200) {
                    log.d("download artifact:", artifact, "source:", id, useProxyId, useMirrorId);
                    InputStream is = response.getEntity().getContent();
                    File target = MMaven.locateArtifact(artifact);
                    if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                        throw new IOException("can't create directory: " + target);
                    }
                    FileOutputStream os = new FileOutputStream(target);
                    MFile.copyFile(is, os);
                    os.close();
                    is.close();
                    if (!artifact.getType().equals("pom")) {
                        Artifact pomArtifact = artifact.createPomArtifact();
                        download = url + '/' + pomArtifact.toLocation();
                        action = new HttpGet(download);
                        response = client.execute(action);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            log.t("download pom:", artifact, "pom", "source:", id, useProxyId, useMirrorId);
                            is = response.getEntity().getContent();
                            target = MMaven.locateArtifact(pomArtifact);
                            os = new FileOutputStream(target);
                            MFile.copyFile(is, os);
                            os.close();
                            is.close();
                        }
                    }
                    client.close();
                    return true;
                }
                client.close();
            }
            catch (Throwable t) {
                log.d("download failed", url, useProxyId, t);
            }
        }
        return false;
    }

    public static Artifact toArtifact(String groupId, String artifactId, String version, String type) {
        return new Artifact(groupId, artifactId, version, type);
    }

    public static Artifact toArtifact(String def) {
        if (def == null) {
            return null;
        }
        if (def.startsWith("mvn:")) {
            String[] parts = def.substring(4).split("/");
            return new Artifact(parts[0], parts[1], parts[2], parts.length > 3 ? parts[3] : null);
        }
        if (def.startsWith("wrap:")) {
            int p = def.indexOf(36);
            if (p > 0) {
                def = def.substring(0, p);
            }
            String[] parts = def.substring(5).split("/");
            return new Artifact(parts[0], parts[1], parts[2], parts.length > 3 ? parts[3] : null);
        }
        if (def.indexOf(47) > -1) {
            String[] parts = def.split("/");
            return new Artifact(parts[0], parts[1], parts[2], parts.length > 3 ? parts[3] : null);
        }
        if (def.indexOf(58) > -1) {
            String[] parts = def.split(":");
            return new Artifact(parts[0], parts[1], parts[3], parts[2]);
        }
        throw new UsageException(new Object[]{"Unknown format"});
    }

    static {
        log = Log.getLog(MMaven.class);
        replacer = new StringPropertyReplacer(){

            @Override
            public String findValueFor(String key) {
                if (key.equals("user.home")) {
                    return MSystem.getUserHome().getAbsolutePath();
                }
                if (key.startsWith("env.")) {
                    return System.getenv(key.substring(4));
                }
                return null;
            }
        };
    }

    public static class Artifact {
        private String groupId;
        private String artifactId;
        private String version;
        private String type;

        private Artifact(String groupId, String artifactId, String version, String type) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            if (type == null) {
                type = "jar";
            }
            this.type = type;
        }

        public Artifact createPomArtifact() {
            if (this.type.equals("pom")) {
                return this;
            }
            return new Artifact(this.groupId, this.artifactId, this.version, "pom");
        }

        public String toLocation() {
            return this.groupId.replace('.', '/') + '/' + this.artifactId + '/' + this.version + '/' + this.artifactId + '-' + this.version + "." + this.type;
        }

        public boolean isRelease() {
            return this.version.indexOf("SNAPSHOT") < 0;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.groupId + "/" + this.artifactId + "/" + this.version + "/" + this.type;
        }
    }
}

