/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.MConfig;
import de.mhus.lib.core.config.XmlConfig;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.errors.MException;
import java.util.HashMap;
import java.util.Locale;

public class Address {
    private static IConfig definition;
    private static HashMap<String, SALUTATION> mapping;
    private static HashMap<String, IConfig> locales;
    protected IProperties attributes;

    public Address(IProperties attributes) {
        this.attributes = attributes;
    }

    public SALUTATION getSalutation() {
        return Address.toSalutation(this.attributes.getString("salutation", null));
    }

    public String getEmail() {
        return this.attributes.getString("email", null);
    }

    public String getNameTitle() {
        return this.attributes.getString("nameTitle", null);
    }

    public String getFirstName() {
        return this.attributes.getString("firstName", null);
    }

    public String getLastName() {
        return this.attributes.getString("lastName", null);
    }

    public String getNameMid() {
        return this.attributes.getString("nameMid", null);
    }

    public String getNameAffix() {
        return this.attributes.getString("nameAffix", null);
    }

    public String getStreet() {
        return this.attributes.getString("street", null);
    }

    public String getHouseNumber() {
        return this.attributes.getString("houseNumber", null);
    }

    public String getTown() {
        return this.attributes.getString("town", null);
    }

    public String getCountry() {
        return this.attributes.getString("country", null);
    }

    public String getZip() {
        return this.attributes.getString("zip", null);
    }

    public String getPhone() {
        return this.attributes.getString("phone", null);
    }

    public String getMobile() {
        return this.attributes.getString("mobile", null);
    }

    public String getFullName(Locale l) {
        IConfig cSal;
        IConfig cAssemble;
        IConfig locale = Address.getLocaleConfig(l);
        if (locale != null && (cAssemble = (IConfig)locale.getNode("assemble")) != null && (cSal = (IConfig)cAssemble.getNode(this.getSalutation().name().toLowerCase())) != null) {
            String template = cSal.getString("", "");
            String out = MString.compileAndExecute(template, this.getAttributes(), "");
            while (out.indexOf("  ") > -1) {
                out = out.replace("  ", " ");
            }
            return out;
        }
        return this.getFirstName() + " " + this.getLastName();
    }

    private static IConfig getLocaleConfig(Locale l) {
        IConfig locale;
        Address.getDefinition();
        if (l == null) {
            l = Locale.getDefault();
        }
        if ((locale = locales.get(l.getLanguage())) == null) {
            locale = locales.get("en");
        }
        return locale;
    }

    public static SALUTATION toSalutation(int salutation) {
        if (salutation >= SALUTATION.values().length || salutation < 0) {
            salutation = 0;
        }
        return SALUTATION.values()[salutation];
    }

    public static int toSalutationInt(String salStr) {
        Address.getDefinition();
        int salutation = MCast.toint(salStr, -1);
        if (salStr != null && salutation == -1) {
            salStr = salStr.trim().toLowerCase();
            Address.getDefinition();
            SALUTATION sal = mapping.get(salStr);
            if (sal == null) {
                return 0;
            }
            return sal.ordinal();
        }
        if (salutation >= SALUTATION.values().length || salutation < 0) {
            salutation = 0;
        }
        return salutation;
    }

    public static String toSalutationString(SALUTATION salutation, Locale l) {
        IConfig cSal;
        IConfig cSingular;
        IConfig locale = Address.getLocaleConfig(l);
        if (locale != null && (cSingular = (IConfig)locale.getNode("singular")) != null && (cSal = (IConfig)cSingular.getNode(salutation.name().toLowerCase())) != null) {
            return cSal.getString("", "");
        }
        switch (salutation) {
            case AGENCY: {
                return "Agency";
            }
            case COMPANY: {
                return "Company";
            }
            case COUPLE: {
                return "Couple";
            }
            case MR: {
                return "Mr";
            }
            case MRS: {
                return "Mrs";
            }
        }
        return "";
    }

    public String getLetterSalutation(Locale l) {
        IConfig cSal;
        IConfig cLetter;
        IConfig locale = Address.getLocaleConfig(l);
        if (locale != null && (cLetter = (IConfig)locale.getNode("letter")) != null && (cSal = (IConfig)cLetter.getNode(this.getSalutation().name().toLowerCase())) != null) {
            String template = cSal.getString("", "");
            return MString.compileAndExecute(template, this.getAttributes(), "");
        }
        switch (this.getSalutation()) {
            default: {
                return "Dear Sir or Madam";
            }
            case MR: {
                return "Dear Sir";
            }
            case MRS: 
        }
        return "Dear Madam";
    }

    private IProperties getAttributes() {
        return this.attributes;
    }

    public static SALUTATION toSalutation(String salStr) {
        int salutation = Address.toSalutationInt(salStr);
        if (salutation < 0 || salutation >= SALUTATION.values().length) {
            salutation = 0;
        }
        return SALUTATION.values()[salutation];
    }

    public static synchronized IConfig getDefinition() {
        if (definition == null) {
            try {
                definition = MConfig.createFromResource(Address.class, "address.xml");
            }
            catch (MException e) {
                MLogUtil.log().w(new Object[]{Address.class, e});
                definition = new XmlConfig();
            }
            mapping = new HashMap();
            locales = new HashMap();
            for (IConfig locale : definition.getNodes("locale")) {
                String val;
                SALUTATION sal2;
                String lang = locale.getString("language", "").toLowerCase();
                locales.put(lang, locale);
                IConfig cMapping = (IConfig)locale.getNode("mapping");
                if (cMapping != null) {
                    for (IConfig cMap : cMapping.getNodes()) {
                        try {
                            sal2 = SALUTATION.valueOf(cMap.getName().toUpperCase());
                            val = cMap.getString("", null);
                            if (!MString.isSet(val)) continue;
                            mapping.put(val.toLowerCase().trim(), sal2);
                        }
                        catch (Throwable sal2) {}
                    }
                }
                if ((cMapping = (IConfig)locale.getNode("plural")) != null) {
                    for (IConfig cMap : cMapping.getNodes()) {
                        try {
                            sal2 = SALUTATION.valueOf(cMap.getName().toUpperCase());
                            val = cMap.getString("", null);
                            if (!MString.isSet(val)) continue;
                            mapping.put(val.toLowerCase().trim(), sal2);
                        }
                        catch (Throwable sal3) {}
                    }
                }
                if ((cMapping = (IConfig)locale.getNode("singular")) == null) continue;
                for (IConfig cMap : cMapping.getNodes()) {
                    try {
                        sal2 = SALUTATION.valueOf(cMap.getName().toUpperCase());
                        val = cMap.getString("", null);
                        if (!MString.isSet(val)) continue;
                        mapping.put(val.toLowerCase().trim(), sal2);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return definition;
    }

    public static void reloadDefinition() {
        definition = null;
        Address.getDefinition();
    }

    public static enum SALUTATION {
        OTHER,
        MR,
        MRS,
        COMPANY,
        AGENCY,
        COUPLE;

    }
}

