/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.mail;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.mail.Mail;
import de.mhus.lib.core.mail.MailTransport;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class PlainTextMail
extends MLog
implements Mail {
    private String from;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String subject;
    private String content;

    public PlainTextMail setFrom(String from) {
        this.from = from;
        return this;
    }

    public PlainTextMail setTo(String[] to) {
        this.to = to;
        return this;
    }

    public PlainTextMail setCc(String[] cc) {
        this.cc = cc;
        return this;
    }

    public PlainTextMail setBcc(String[] bcc) {
        this.bcc = bcc;
        return this;
    }

    public PlainTextMail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public PlainTextMail setContent(String content) {
        this.content = content;
        return this;
    }

    @Override
    public void send(MailTransport transport) throws Exception {
        InternetAddress[] toAddresses = new InternetAddress[this.to.length];
        for (int i = 0; i < this.to.length; ++i) {
            toAddresses[i] = new InternetAddress(this.to[i]);
        }
        InternetAddress[] ccAddresses = null;
        if (this.cc != null && this.cc.length > 0) {
            ccAddresses = new InternetAddress[this.cc.length];
            for (int i = 0; i < this.cc.length; ++i) {
                ccAddresses[i] = new InternetAddress(this.cc[i]);
            }
        }
        InternetAddress[] bccAddresses = null;
        if (this.bcc != null && this.bcc.length > 0) {
            bccAddresses = new InternetAddress[this.bcc.length];
            for (int i = 0; i < this.bcc.length; ++i) {
                bccAddresses[i] = new InternetAddress(this.bcc[i]);
            }
        }
        MimeMessage msg = new MimeMessage(transport.getSession());
        msg.setFrom((Address)(MString.isSet(this.from) ? new InternetAddress(this.from) : transport.getFrom()));
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        if (ccAddresses != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        if (bccAddresses != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        msg.setSubject(this.subject, "UTF-8");
        msg.setSentDate(new Date());
        msg.setText(this.content, "UTF-8");
        this.log().t(this.content);
        Transport.send((Message)msg);
    }

    public String toString() {
        return MSystem.toString(this, this.subject, "from", this.from, "to", this.to, "cc", this.cc, "bcc", this.bcc);
    }
}

