/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.cfg.CfgString;
import de.mhus.lib.core.parser.StringPropertyReplacer;
import de.mhus.lib.errors.NotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class SOfficeConnector {
    private static CfgString BINARY = new CfgString((Object)SOfficeConnector.class, "binary", "soffice");
    private String binary = (String)BINARY.value();
    private boolean valid = false;
    private String version;

    public SOfficeConnector() {
        this.findVersion();
    }

    private void findVersion() {
        this.valid = false;
        this.version = null;
        if (this.binary == null || this.binary.indexOf("soffice") < 0) {
            return;
        }
        try {
            String[] res = MSystem.execute(this.binary, "--version");
            this.version = res[0];
            this.valid = MString.isSet(this.version) && this.version.startsWith("LibreOffice ");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getBinary() {
        return this.binary;
    }

    public void setBinary(String binary) {
        this.binary = binary;
        this.findVersion();
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getVersion() {
        return this.version;
    }

    public String convertToPdf(String in, String outDir) throws NotFoundException, IOException {
        return this.convertTo("pdf", in, outDir);
    }

    public String convertTo(String format, String in, String outDir) throws NotFoundException, IOException {
        if (!this.valid) {
            throw new NotFoundException(new Object[]{"LibreOffice not found"});
        }
        File inFile = new File(in);
        if (!inFile.exists() || !inFile.isFile()) {
            throw new FileNotFoundException(in);
        }
        if (outDir != null) {
            File outFile = new File(outDir);
            if (outFile.exists() && !outFile.isDirectory()) {
                throw new IOException("out directory is not a directory: " + outDir);
            }
            if (!outFile.exists() && !outFile.mkdirs()) {
                throw new IOException("can't create out directory: " + outDir);
            }
        }
        String[] res = null;
        res = outDir == null ? MSystem.execute(this.binary, "--headless", "-convert-to", format, in) : MSystem.execute(this.binary, "--headless", "-convert-to", format, "-outdir", outDir, in);
        for (String line : res[0].split("\n")) {
            if (!(line = line.trim()).startsWith("convert ")) continue;
            int p1 = line.indexOf(" -> ");
            int p2 = line.indexOf(" using", p1);
            if (p1 <= 0 || p2 <= 0) continue;
            return line.substring(p1 + 4, p2);
        }
        return null;
    }

    public static void main(String[] args) throws NotFoundException, IOException {
        SOfficeConnector inst = new SOfficeConnector();
        inst.setBinary("/Users/mikehummel/dev/LibreOffice.app/Contents/MacOS/soffice");
        System.out.println(inst.getVersion());
        String to = inst.convertToPdf("/Users/mikehummel/Devices.ods", "/tmp");
        System.out.println(to);
    }

    public String toString() {
        return this.version;
    }

    public static void replace(File from, File to, StringPropertyReplacer replacer) throws ZipException, IOException {
        ZipFile inZip = new ZipFile(from);
        FileOutputStream os = new FileOutputStream(to);
        ZipOutputStream outZip = new ZipOutputStream(os);
        Enumeration<? extends ZipEntry> entries = inZip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry inNext = entries.nextElement();
            InputStream isZip = inZip.getInputStream(inNext);
            ZipEntry e = new ZipEntry(inNext.getName());
            outZip.putNextEntry(e);
            if (inNext.getName().equals("content.xml") || inNext.getName().equals("word/document.xml")) {
                String content = MFile.readFile(isZip);
                content = replacer.process(content);
                MFile.writeFile(outZip, content);
            } else {
                MFile.copyFile(isZip, outZip);
            }
            outZip.closeEntry();
            isZip.close();
        }
        outZip.close();
        inZip.close();
    }
}

