/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cfg;

import de.mhus.lib.core.cfg.CfgValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;

public class UpdaterCfg {
    private HashMap<String, HashMap<String, WeakHashMap<CfgValue, String>>> registry = new HashMap();

    protected synchronized WeakHashMap<CfgValue, String> getCfgContainer(String owner, String path) {
        WeakHashMap<CfgValue<Object>, String> pathContainer;
        HashMap<String, WeakHashMap<CfgValue<Object>, String>> ownerContainer = this.registry.get(owner);
        if (ownerContainer == null) {
            ownerContainer = new HashMap();
            this.registry.put(owner, ownerContainer);
        }
        if ((pathContainer = ownerContainer.get(path)) == null) {
            pathContainer = new WeakHashMap();
            ownerContainer.put(path, pathContainer);
        }
        return pathContainer;
    }

    protected synchronized HashMap<String, WeakHashMap<CfgValue, String>> getOwnerContainers(String owner) {
        HashMap<String, WeakHashMap<CfgValue<Object>, String>> ownerContainer = this.registry.get(owner);
        if (ownerContainer == null) {
            ownerContainer = new HashMap();
            this.registry.put(owner, ownerContainer);
        }
        return ownerContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(CfgValue configValue) {
        HashMap<String, HashMap<String, WeakHashMap<CfgValue, String>>> hashMap = this.registry;
        synchronized (hashMap) {
            this.getCfgContainer(configValue.getOwner(), configValue.getPath()).put(configValue, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(String owner) {
        LinkedList<CfgValue> list = new LinkedList<CfgValue>();
        HashMap<String, HashMap<String, WeakHashMap<CfgValue, String>>> hashMap = this.registry;
        synchronized (hashMap) {
            for (WeakHashMap<CfgValue, String> pathContainer : this.getOwnerContainers(owner).values()) {
                list.addAll(pathContainer.keySet());
            }
        }
        for (CfgValue item : list) {
            if (owner != null && !item.isOwner(owner)) continue;
            item.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(String owner, String path) {
        LinkedList<CfgValue> list = null;
        HashMap<String, HashMap<String, WeakHashMap<CfgValue, String>>> hashMap = this.registry;
        synchronized (hashMap) {
            list = new LinkedList<CfgValue>(this.getCfgContainer(owner, path).keySet());
        }
        for (CfgValue item : list) {
            if (owner != null && !item.isOwner(owner) || !path.equals(item.getPath())) continue;
            item.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CfgValue> getList() {
        LinkedList<CfgValue> list = new LinkedList<CfgValue>();
        HashMap<String, HashMap<String, WeakHashMap<CfgValue, String>>> hashMap = this.registry;
        synchronized (hashMap) {
            for (HashMap<String, WeakHashMap<CfgValue, String>> ownerContainer : this.registry.values()) {
                for (WeakHashMap<CfgValue, String> pathContainer : ownerContainer.values()) {
                    list.addAll(pathContainer.keySet());
                }
            }
        }
        return list;
    }
}

