/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cast;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.cast.Caster;
import de.mhus.lib.core.logging.Log;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ObjectToCalendar
implements Caster<Object, Calendar> {
    private static final Log log = Log.getLog(ObjectToCalendar.class);

    @Override
    public Class<? extends Calendar> getToClass() {
        return Calendar.class;
    }

    @Override
    public Class<? extends Object> getFromClass() {
        return Object.class;
    }

    @Override
    public Calendar cast(Object in, Calendar def) {
        return this.cast(in, def, Locale.getDefault());
    }

    public Calendar cast(Object in, Calendar def, Locale locale) {
        if (in == null) {
            return def;
        }
        if (in instanceof Calendar) {
            return (Calendar)in;
        }
        if (in instanceof Date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)in);
            return c;
        }
        try {
            String ins = MCast.toString(in);
            Calendar ret = ObjectToCalendar.toCalendar(ins, locale);
            if (ret == null) {
                return def;
            }
            return ret;
        }
        catch (Throwable t) {
            return def;
        }
    }

    public static Calendar toCalendar(String in, Locale locale) {
        if (in == null) {
            return null;
        }
        try {
            int day;
            int month2;
            Calendar c = Calendar.getInstance();
            if (in.equals("now") || in.equals("jetzt")) {
                return c;
            }
            boolean retOk = false;
            c.clear();
            String date = in.trim();
            int hour = 0;
            int min = 0;
            int sec = 0;
            int millies = 0;
            String zone = null;
            int sep = 63;
            if (MString.isIndex(date, '_')) {
                sep = 95;
            } else if (MString.isIndex(date, ' ')) {
                sep = 32;
            } else if (MString.isIndex(date, 'T')) {
                sep = 84;
            }
            if (sep == 32 && MString.isIndex(date, ',')) {
                int p1 = date.indexOf(32);
                int p2 = date.indexOf(44);
                try {
                    month2 = ObjectToCalendar.toMonth(date.substring(0, p1));
                    day = Integer.parseInt(date.substring(p1 + 1, p2).trim());
                    date = date.substring(p2 + 1).trim();
                    p1 = date.indexOf(32);
                    int year = Integer.parseInt(date.substring(0, p1).trim());
                    c.set(year, month2, day);
                    date = " " + date.substring(p1 + 1).trim();
                    sep = 32;
                    retOk = true;
                }
                catch (NumberFormatException month2) {
                    // empty catch block
                }
            }
            if (sep != 63) {
                String apm = null;
                String time = MString.afterIndex(date, (char)sep).trim();
                date = MString.beforeIndex(in, (char)sep).trim();
                char sep2 = '?';
                if (MString.isIndex(time, ' ')) {
                    sep2 = ' ';
                } else if (MString.isIndex(time, '_')) {
                    sep2 = '_';
                } else if (MString.isIndex(time, 'Z')) {
                    sep2 = 'Z';
                }
                if (sep2 == ' ') {
                    zone = MString.afterIndex(time, sep2).trim();
                    time = MString.beforeIndex(time, sep2).trim();
                    if (zone.startsWith("am") || zone.startsWith("pm")) {
                        apm = zone.substring(0, 2);
                        zone = zone.substring(2).trim();
                    }
                } else if (sep2 != '?') {
                    zone = MString.afterIndex(time, sep2).trim();
                    time = MString.beforeIndex(time, sep2).trim();
                } else if (time.startsWith("+") || time.startsWith("-")) {
                    zone = time.trim();
                    time = "";
                }
                if (MString.isIndex(time, '.')) {
                    millies = ObjectToCalendar.toint(MString.afterLastIndex(time, '.'), 0);
                    time = MString.beforeLastIndex(time, '.');
                }
                if ((time = time.trim()).length() > 0) {
                    String sep3 = null;
                    if (MString.isIndex(time, ':')) {
                        sep3 = "\\:";
                    } else if (MString.isIndex(time, '-')) {
                        sep3 = "-";
                    } else if (MString.isIndex(time, '.')) {
                        sep3 = "\\.";
                    }
                    String[] parts = time.split(sep3);
                    if (parts.length > 1) {
                        hour = ObjectToCalendar.toint(parts[0], 0);
                        min = ObjectToCalendar.toint(parts[1], 0);
                        if (parts.length > 2) {
                            sec = ObjectToCalendar.toint(parts[2], 0);
                        }
                    }
                    if (apm != null) {
                        if (hour == 0) {
                            min = 0;
                            sec = 0;
                            millies = 0;
                            zone = "";
                        } else if (apm.equals("am")) {
                            if (hour == 12) {
                                hour = 0;
                            }
                        } else if (apm.equals("pm") && hour != 12) {
                            hour += 12;
                        }
                    }
                    c.set(11, hour);
                    c.set(12, min);
                    c.set(14, sec * 1000 + millies);
                    if (zone != null && zone.length() > 0) {
                        if (zone.startsWith("-") || zone.startsWith("+")) {
                            zone = "GMT" + zone;
                        }
                        TimeZone tz = TimeZone.getTimeZone(zone);
                        c.setTimeZone(tz);
                    }
                }
            }
            if (retOk) {
                return c;
            }
            if (date.indexOf(45) > 0) {
                String[] parts = date.split("-");
                if (parts.length == 3) {
                    int year = Integer.parseInt(parts[0]);
                    if (parts[0].length() == 2) {
                        year += 2000;
                    }
                    month2 = ObjectToCalendar.toMonth(parts[1]);
                    day = Integer.parseInt(parts[2]);
                    c.set(year, month2, day);
                } else if (parts.length == 2) {
                    c.set(2, ObjectToCalendar.toMonth(parts[0]));
                    c.set(5, Integer.parseInt(parts[1]));
                } else {
                    parts = date.split("\\.");
                    if (parts.length == 3) {
                        int year = Integer.parseInt(parts[2]);
                        if (parts[2].length() == 2) {
                            year += 2000;
                        }
                        month2 = ObjectToCalendar.toMonth(parts[1]);
                        day = Integer.parseInt(parts[0]);
                        c.set(year, month2, day);
                    } else if (parts.length == 2) {
                        int year = Integer.parseInt(parts[1]);
                        if (parts[1].length() == 2) {
                            year += 2000;
                        }
                        month2 = ObjectToCalendar.toMonth(parts[0]);
                        c.set(2, month2);
                        c.set(1, year);
                    } else {
                        parts = date.split("/");
                        if (parts.length == 3) {
                            if (Locale.US.equals(locale)) {
                                c.set(Integer.parseInt(parts[2]), ObjectToCalendar.toMonth(parts[0]), Integer.parseInt(parts[1]));
                            } else {
                                c.set(Integer.parseInt(parts[2]), ObjectToCalendar.toMonth(parts[1]), Integer.parseInt(parts[0]));
                            }
                        }
                        if (parts.length == 2) {
                            c.set(2, ObjectToCalendar.toMonth(parts[0]));
                            c.set(1, Integer.parseInt(parts[1]));
                        }
                    }
                }
                return c;
            }
            if (date.indexOf(46) > 0) {
                String[] parts = date.split("\\.");
                if (parts.length == 3) {
                    int year = Integer.parseInt(parts[2]);
                    if (parts[2].length() == 2) {
                        year += 2000;
                    }
                    month2 = Integer.parseInt(parts[1]) - 1;
                    day = Integer.parseInt(parts[0]);
                    c.set(year, month2, day);
                    return c;
                }
                if (parts.length == 2) {
                    int year = Integer.parseInt(parts[1]);
                    if (parts[1].length() == 2) {
                        year += 2000;
                    }
                    month2 = Integer.parseInt(parts[0]) - 1;
                    c.set(year, month2, 1);
                    return c;
                }
                return null;
            }
            if (date.indexOf(47) > 0) {
                String[] parts = date.split("/");
                if (Locale.US.equals(locale)) {
                    if (parts.length == 3) {
                        int year = Integer.parseInt(parts[2]);
                        if (parts[2].length() == 2) {
                            year += 2000;
                        }
                        month2 = Integer.parseInt(parts[0]) - 1;
                        day = Integer.parseInt(parts[1]);
                        c.set(year, month2, day);
                        return c;
                    }
                    if (parts.length == 2) {
                        int year = Integer.parseInt(parts[1]);
                        if (parts[1].length() == 2) {
                            year += 2000;
                        }
                        month2 = Integer.parseInt(parts[0]) - 1;
                        c.set(year, month2, 1);
                        return c;
                    }
                    return null;
                }
                if (parts.length == 3) {
                    int year = Integer.parseInt(parts[2]);
                    if (parts[2].length() == 2) {
                        year += 2000;
                    }
                    month2 = Integer.parseInt(parts[1]) - 1;
                    day = Integer.parseInt(parts[0]);
                    c.set(year, month2, day);
                    return c;
                }
                if (parts.length == 2) {
                    int year = Integer.parseInt(parts[1]);
                    if (parts[1].length() == 2) {
                        year += 2000;
                    }
                    month2 = Integer.parseInt(parts[0]) - 1;
                    c.set(year, month2, 1);
                    return c;
                }
                return null;
            }
            try {
                long ts = Long.valueOf(date);
                c.setTimeInMillis(ts);
                return c;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        catch (Throwable e) {
            log.t(in, e);
            return null;
        }
    }

    public static int toMonth(String in) {
        try {
            int out = Integer.parseInt(in);
            if (out > 0 && out < 13) {
                return out - 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        switch (in = in.toLowerCase()) {
            case "jan": 
            case "januar": 
            case "january": {
                return 0;
            }
            case "feb": 
            case "februar": 
            case "february": {
                return 1;
            }
            case "mrz": 
            case "march": 
            case "m\u00e4rz": {
                return 2;
            }
            case "apr": 
            case "april": {
                return 3;
            }
            case "mai": 
            case "may": {
                return 4;
            }
            case "jun": 
            case "juni": 
            case "june": {
                return 5;
            }
            case "jul": 
            case "juli": 
            case "july": {
                return 6;
            }
            case "aug": 
            case "august": {
                return 7;
            }
            case "sep": 
            case "september": 
            case "septembre": {
                return 8;
            }
            case "okt": 
            case "oct": 
            case "oktober": 
            case "october": {
                return 9;
            }
            case "nov": 
            case "november": {
                return 10;
            }
            case "dez": 
            case "dec": 
            case "dezember": 
            case "december": {
                return 11;
            }
        }
        throw new NumberFormatException(in);
    }

    private static int toint(String in, int def) {
        if (in == null) {
            return def;
        }
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }
}

