/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MTimeInterval;
import de.mhus.lib.core.jmx.MJmx;
import de.mhus.lib.core.service.UniqueId;

public class MStopWatch
extends MJmx {
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_RUNNING = 1;
    private static final int STATUS_STOPPED = 2;
    private long count = 0L;
    private long start = 0L;
    private long stop = 0L;
    private String name;

    public MStopWatch() {
        this.name = "StopWatch " + MApi.lookup(UniqueId.class).nextUniqueId();
    }

    public MStopWatch(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MStopWatch start() {
        MStopWatch mStopWatch = this;
        synchronized (mStopWatch) {
            if (this.start != 0L && this.stop != 0L) {
                this.start = System.currentTimeMillis() - (this.stop - this.start);
                this.stop = 0L;
                ++this.count;
            } else if (this.start == 0L) {
                this.start = System.currentTimeMillis();
                ++this.count;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MStopWatch stop() {
        MStopWatch mStopWatch = this;
        synchronized (mStopWatch) {
            if (this.start != 0L && this.stop == 0L) {
                this.stop = System.currentTimeMillis();
            }
        }
        return this;
    }

    public long getCurrentTime() {
        if (this.start == 0L) {
            return 0L;
        }
        if (this.stop == 0L) {
            return System.currentTimeMillis() - this.start;
        }
        return this.stop - this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MStopWatch reset() {
        MStopWatch mStopWatch = this;
        synchronized (mStopWatch) {
            this.start = 0L;
            this.stop = 0L;
        }
        return this;
    }

    public int getStatus() {
        if (this.start == 0L && this.stop == 0L) {
            return 0;
        }
        if (this.stop == 0L) {
            return 1;
        }
        return 2;
    }

    public boolean isRunning() {
        return this.getStatus() == 1;
    }

    public String getStatusAsString() {
        switch (this.getStatus()) {
            case 0: {
                return "initial";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "stopped";
            }
        }
        return "unknown";
    }

    public long getCurrentSeconds() {
        return this.getCurrentTime() / 1000L;
    }

    public long getCurrentMinutes() {
        return this.getCurrentSeconds() / 60L;
    }

    public String getCurrentMinutesAsString() {
        long sec = this.getCurrentSeconds();
        return String.valueOf(sec / 60L) + ':' + MCast.toString((int)(sec % 60L), 2);
    }

    public String getCurrentTimeAsString() {
        return MTimeInterval.getIntervalAsString(this.getCurrentTime());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name + "=" + this.getCurrentTimeAsString();
    }

    public long getCount() {
        return this.count;
    }
}

