/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.MMath;
import de.mhus.lib.core.cast.Caster;
import de.mhus.lib.core.cast.DoubleToString;
import de.mhus.lib.core.cast.FloatToString;
import de.mhus.lib.core.cast.ObjectToBigDecimal;
import de.mhus.lib.core.cast.ObjectToBoolean;
import de.mhus.lib.core.cast.ObjectToByte;
import de.mhus.lib.core.cast.ObjectToCalendar;
import de.mhus.lib.core.cast.ObjectToDate;
import de.mhus.lib.core.cast.ObjectToDouble;
import de.mhus.lib.core.cast.ObjectToFloat;
import de.mhus.lib.core.cast.ObjectToInteger;
import de.mhus.lib.core.cast.ObjectToLong;
import de.mhus.lib.core.cast.ObjectToShort;
import de.mhus.lib.core.cast.ObjectToSqlDate;
import de.mhus.lib.core.cast.ObjectToString;
import de.mhus.lib.core.cast.ObjectToUUID;
import de.mhus.lib.core.io.MObjectInputStream;
import de.mhus.lib.core.util.VectorMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class MCast {
    private static final char[] HEX_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static VectorMap<Class<?>, Class<?>, Caster<?, ?>> casters = new VectorMap();
    private static final ObjectToBoolean OBJECT_TO_BOOLEAN = new ObjectToBoolean();
    private static final ObjectToInteger OBJECT_TO_INTEGER = new ObjectToInteger();
    private static final ObjectToByte OBJECT_TO_BYTE = new ObjectToByte();
    private static final ObjectToShort OBJECT_TO_SHORT = new ObjectToShort();
    private static final ObjectToLong OBJECT_TO_LONG = new ObjectToLong();
    private static final ObjectToDouble OBJECT_TO_DOUBLE = new ObjectToDouble();
    private static final ObjectToFloat OBJECT_TO_FLOAT = new ObjectToFloat();
    private static final ObjectToCalendar OBJECT_TO_CALENDAR = new ObjectToCalendar();
    private static final ObjectToDate OBJECT_TO_DATE = new ObjectToDate();
    private static final ObjectToSqlDate OBJECT_TO_SQLDATE = new ObjectToSqlDate();
    private static final DoubleToString DOUBLE_TO_STRING = new DoubleToString();
    private static final FloatToString FLOAT_TO_STRING = new FloatToString();
    private static final ObjectToString OBJECT_TO_STRING = new ObjectToString();
    private static final ObjectToBigDecimal OBJECT_TO_BIGDECIMAL = new ObjectToBigDecimal();
    private static final int UNIT_MAX;

    public static String toCurrencyString(double _in) {
        _in = (double)Math.round(_in * 100.0) / 100.0;
        StringBuilder out = new StringBuilder();
        out.append(_in);
        int pos = out.indexOf(".");
        if (pos >= 0) {
            out.setCharAt(pos, ',');
        } else {
            pos = out.indexOf(",");
        }
        if (pos <= 0) {
            out.append(",00");
        } else if (out.length() - pos <= 2) {
            out.append("0");
        }
        return out.toString();
    }

    public static void addCaster(Caster<?, ?> caster, boolean overwrite) {
        if (!overwrite && casters.containsKey(caster.getFromClass(), caster.getToClass())) {
            return;
        }
        casters.put(caster.getFromClass(), caster.getToClass(), caster);
    }

    public static java.util.Date toDate(Object in, java.util.Date def) {
        return OBJECT_TO_DATE.cast(in, def);
    }

    public static java.util.Date toDate(Object in, java.util.Date def, Locale locale) {
        return OBJECT_TO_DATE.cast(in, def, locale);
    }

    public static Calendar toCalendar(Object in) {
        return OBJECT_TO_CALENDAR.cast(in, null);
    }

    public static Calendar toCalendar(java.util.Date _in, TimeZone tz, Locale l) {
        Calendar calendar = Calendar.getInstance(tz, l);
        calendar.setTime(_in);
        return calendar;
    }

    public static Calendar toCalendar(String in) {
        return OBJECT_TO_CALENDAR.cast((Object)in, null);
    }

    public static Calendar toCalendar(String in, Calendar def) {
        return OBJECT_TO_CALENDAR.cast((Object)in, def);
    }

    public static String toBinaryString(byte[] in) {
        char[] hex = new char[2 * in.length];
        int index = 0;
        for (byte b : in) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex);
    }

    public static byte[] fromBinaryString(String in) {
        byte[] out = new byte[in.length() / 2];
        for (int i = 0; i < out.length; ++i) {
            out[i] = MCast.byteFromHex(in, i * 2);
        }
        return out;
    }

    public static byte byteFromHex(String in, int offset) {
        int i = Integer.parseInt(in.substring(offset, offset + 2), 16);
        byte b = (byte)(i & 0xFF);
        return b;
    }

    public static String toHex2String(byte in) {
        char[] hex = new char[2];
        int v = in & 0xFF;
        hex[0] = HEX_CHAR_TABLE[v >>> 4];
        hex[1] = HEX_CHAR_TABLE[v & 0xF];
        return new String(hex);
    }

    public static boolean toboolean(Object _in, boolean _default) {
        return OBJECT_TO_BOOLEAN.toBoolean(_in, _default, null);
    }

    public static float tofloat(Object in, float def) {
        return OBJECT_TO_FLOAT.toFloat(in, def, null);
    }

    public static double todouble(Object in, double def) {
        return OBJECT_TO_DOUBLE.toDouble(in, def, null);
    }

    public static BigDecimal toBigDecimal(Object in, BigDecimal def) {
        return OBJECT_TO_BIGDECIMAL.cast(in, def, null);
    }

    public static double todoubleEuropean(String in, double def) {
        if (in == null) {
            return def;
        }
        in = in.replaceAll(" ", "").replaceAll("\\.", "").replace(',', '.');
        return OBJECT_TO_DOUBLE.toDouble(in, def, null);
    }

    public static double todoubleUS(String in, double def) {
        if (in == null) {
            return def;
        }
        in = in.replaceAll(" ", "").replaceAll(",", "");
        return OBJECT_TO_DOUBLE.toDouble(in, def, null);
    }

    public static double todouble(String in, double def, Locale locale) {
        if (in == null) {
            return def;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            NumberFormat nf = NumberFormat.getInstance(locale);
            return nf.parse(in).doubleValue();
        }
        catch (Throwable t) {
            return def;
        }
    }

    public static int toint(Object in, int def) {
        return OBJECT_TO_INTEGER.toInt(in, def, null);
    }

    public static long tolong(Object in, long def) {
        return OBJECT_TO_LONG.toLong(in, def, null);
    }

    public static byte tobyte(Object in, byte def) {
        return OBJECT_TO_BYTE.toByte(in, def, null);
    }

    public static short toshort(Object in, short def) {
        return OBJECT_TO_SHORT.toShort(in, def, null);
    }

    public static String toString(double in) {
        return DOUBLE_TO_STRING.toString(in);
    }

    public static String toString(float in) {
        return FLOAT_TO_STRING.toString(in);
    }

    public static String toString(boolean _in) {
        if (_in) {
            return "true";
        }
        return "false";
    }

    public static String toString(int _in) {
        return Integer.toString(_in);
    }

    public static String toString(int _in, int _digits) {
        StringBuilder out = new StringBuilder().append(Integer.toString(_in));
        while (out.length() < _digits) {
            out.insert(0, '0');
        }
        return out.toString();
    }

    public static String toString(long _in, int _digits) {
        StringBuilder out = new StringBuilder().append(Long.toString(_in));
        while (out.length() < _digits) {
            out.insert(0, '0');
        }
        return out.toString();
    }

    public static String toString(long _in) {
        return String.valueOf(_in);
    }

    public static String toHex2String(int _in) {
        String out = Integer.toHexString(_in).toUpperCase();
        if (out.length() == 1) {
            out = "0" + out;
        }
        return out;
    }

    public static String toHex2LowerString(int _in) {
        String out = Integer.toHexString(_in);
        if (out.length() == 1) {
            out = "0" + out;
        }
        return out;
    }

    public static String toHex4String(int _in) {
        return MCast.toHex2String(_in / 256) + MCast.toHex2String(_in % 256);
    }

    public static String[] toStringArray(List<?> _v) {
        String[] out = new String[_v.size()];
        for (int i = 0; i < _v.size(); ++i) {
            Object o = _v.get(i);
            out[i] = o == null ? null : o.toString();
        }
        return out;
    }

    public static int tointFromHex(String _in) {
        int out = 0;
        for (int i = 0; i < _in.length(); ++i) {
            int x = 0;
            char c = _in.charAt(i);
            if (c >= '0' && c <= '9') {
                x = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                x = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                x = c - 65 + 10;
            } else {
                throw new NumberFormatException(_in);
            }
            out = out * 16 + x;
        }
        return out;
    }

    public static String toString(byte[] in) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < in.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(Byte.toString(in[i]));
        }
        return sb.toString();
    }

    public static byte[] toByteArray(String in) {
        if (in.length() == 0) {
            return new byte[0];
        }
        int offset = 0;
        int cnt = 0;
        while ((offset = in.indexOf(44, offset + 1)) >= 0) {
            ++cnt;
        }
        offset = 0;
        int old = 0;
        byte[] out = new byte[cnt + 1];
        cnt = 0;
        while ((offset = in.indexOf(44, offset + 1)) >= 0) {
            out[cnt] = Byte.parseByte(in.substring(old, offset));
            ++cnt;
            old = offset + 1;
        }
        out[cnt] = Byte.parseByte(in.substring(old));
        return out;
    }

    public static String toString(String firstLine, StackTraceElement[] trace) {
        StringBuilder sb = new StringBuilder();
        if (firstLine != null) {
            sb.append(firstLine).append('\n');
        }
        if (trace == null) {
            return sb.toString();
        }
        for (int i = 0; i < trace.length; ++i) {
            sb.append("\tat ").append(trace[i].getClassName()).append('.').append(trace[i].getMethodName()).append('(').append(trace[i].getFileName()).append(':').append(trace[i].getLineNumber()).append(")\n");
        }
        return sb.toString();
    }

    public static Map<String, Object> toIndexedMap(Object ... values) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (int i = 0; i < values.length; ++i) {
            out.put(MCast.toString(i), values[i]);
        }
        return out;
    }

    public static String objectToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return MCast.toString((Integer)value);
        }
        if (value instanceof Long) {
            return MCast.toString((Long)value);
        }
        if (value instanceof Double) {
            return MCast.toString((Double)value);
        }
        if (value instanceof Float) {
            return MCast.toString((Float)value);
        }
        if (value instanceof java.util.Date) {
            return MCast.toString((java.util.Date)value);
        }
        if (value instanceof Calendar) {
            return MCast.toString((Calendar)value);
        }
        return value.toString();
    }

    public static java.util.Date objectToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        return MCast.toDate(String.valueOf(value), null);
    }

    public static Date toSqlDate(java.util.Date date) {
        return new Date(date.getTime());
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String toString(Object in) {
        if (in == null) {
            return "";
        }
        return OBJECT_TO_STRING.cast(in, "");
    }

    public static String toString(Object in, String def) {
        if (in == null) {
            return def;
        }
        return OBJECT_TO_STRING.cast(in, def);
    }

    public static Object toType(Object in, Class<?> type, Object def) {
        if (in == null) {
            return def;
        }
        if (type.isInstance(in)) {
            return in;
        }
        if (type.isArray()) {
            if (in.getClass().isArray()) {
                Class<?> arrayType = type.getComponentType();
                int length = Array.getLength(in);
                Object out = Array.newInstance(arrayType, length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(in, i);
                    value = MCast.toType(value, arrayType, null);
                    Array.set(out, i, value);
                }
                return out;
            }
            if (in instanceof String) {
                String[] parts = ((String)in).split(";");
                Class<?> arrayType = type.getComponentType();
                int length = parts.length;
                Object out = Array.newInstance(arrayType, length);
                for (int i = 0; i < length; ++i) {
                    Object value = parts[i];
                    value = MCast.toType(value, arrayType, null);
                    Array.set(out, i, value);
                }
                return out;
            }
            if (in instanceof Collection) {
                Collection c = (Collection)in;
                Class<?> arrayType = type.getComponentType();
                int length = c.size();
                Object out = Array.newInstance(arrayType, length);
                Iterator iter = c.iterator();
                for (int i = 0; i < length; ++i) {
                    Object value = iter.next();
                    value = MCast.toType(value, arrayType, null);
                    Array.set(out, i, value);
                }
                return out;
            }
            return def;
        }
        Caster<?, ?> caster = casters.get(in.getClass(), type);
        if (caster == null) {
            if (String.class.isAssignableFrom(type)) {
                return MCast.toString(in);
            }
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return MCast.toboolean(in, def == null ? false : MCast.toboolean(def, false));
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return MCast.toint(in, def == null ? 0 : MCast.toint(def, 0));
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                return MCast.tolong(in, def == null ? 0L : MCast.tolong(def, 0L));
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                return MCast.todouble(in, def == null ? 0.0 : MCast.todouble(def, 0.0));
            }
            if (Byte.TYPE.isAssignableFrom(type)) {
                return MCast.tobyte(in, def == null ? (byte)0 : MCast.tobyte(def, (byte)0));
            }
            if (Short.TYPE.isAssignableFrom(type)) {
                return MCast.toshort(in, def == null ? (short)0 : MCast.toshort(def, (short)0));
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                return Float.valueOf(MCast.tofloat(in, def == null ? 0.0f : MCast.tofloat(def, 0.0f)));
            }
            caster = casters.get(Object.class, type);
        }
        if (caster == null) {
            return def;
        }
        return caster.cast(in, def);
    }

    public static Object getDefaultPrimitive(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            type = type.getComponentType();
            return Array.newInstance(type, 0);
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Character.TYPE) {
            return Character.valueOf(' ');
        }
        return null;
    }

    public static Object getDefaultPrimitive(String type) {
        if (type == null) {
            return null;
        }
        if (type.endsWith("[]")) {
            if ("int".equals(type = type.substring(0, type.length() - 2))) {
                return new int[0];
            }
            if ("long".equals(type)) {
                return new long[0];
            }
            if ("short".equals(type)) {
                return new short[0];
            }
            if ("double".equals(type)) {
                return new double[0];
            }
            if ("float".equals(type)) {
                return new float[0];
            }
            if ("byte".equals(type)) {
                return new byte[0];
            }
            if ("boolean".equals(type)) {
                return new boolean[0];
            }
            if ("char".equals(type)) {
                return new char[0];
            }
            return null;
        }
        if ("int".equals(type)) {
            return 0;
        }
        if ("long".equals(type)) {
            return 0L;
        }
        if ("short".equals(type)) {
            return (short)0;
        }
        if ("double".equals(type)) {
            return 0.0;
        }
        if ("float".equals(type)) {
            return Float.valueOf(0.0f);
        }
        if ("byte".equals(type)) {
            return (byte)0;
        }
        if ("boolean".equals(type)) {
            return false;
        }
        if ("char".equals(type)) {
            return Character.valueOf(' ');
        }
        return null;
    }

    public static byte[] toBinary(Object value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(value);
        oos.close();
        bos.close();
        return bos.toByteArray();
    }

    public static Object fromBinary(byte[] bin) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bin);
        MObjectInputStream ois = new MObjectInputStream(bis);
        Object obj = ois.readObject();
        ois.close();
        bis.close();
        return obj;
    }

    public static long[] toLongIntervalValues(String def) {
        if (def == null) {
            return null;
        }
        if ((def = def.trim()).equals("*")) {
            return null;
        }
        int p1 = def.indexOf(47);
        if (p1 > 0) {
            String left = def.substring(0, p1);
            String right = def.substring(p1 + 1);
            int p2 = left.indexOf(45, 1);
            long start = 0L;
            long stop = 0L;
            if (p2 > 0) {
                start = MCast.tolong(left.substring(0, p2), 0L);
                stop = MCast.tolong(left.substring(p2 + 1), 0L);
            } else {
                stop = MCast.tolong(left, 0L);
            }
            long interval = Math.max(1L, Math.abs(MCast.tolong(right, 0L)));
            long len = (stop - start) / interval;
            long[] out = new long[(int)len];
            int i = 0;
            while ((long)i < len) {
                out[i] = start;
                start += interval;
                ++i;
            }
            return out;
        }
        p1 = def.indexOf(44);
        if (p1 > 0) {
            String[] parts = def.split(",");
            long[] out = new long[parts.length];
            boolean needOrder = false;
            for (int i = 0; i < out.length; ++i) {
                out[i] = MCast.tolong(parts[i], 0L);
                if (i == 0 || out[i - 1] < out[1]) continue;
                needOrder = true;
            }
            if (needOrder) {
                out = MCollection.order(out, false);
            }
            return out;
        }
        try {
            return new long[]{Long.valueOf(def)};
        }
        catch (NumberFormatException e) {
            return new long[0];
        }
    }

    public static int[] toIntIntervalValues(String def, int defStart, int defStop) {
        if (def == null) {
            return null;
        }
        if ((def = def.trim()).equals("*")) {
            return null;
        }
        int p1 = def.indexOf(47);
        if (p1 > 0) {
            String left = def.substring(0, p1);
            String right = def.substring(p1 + 1);
            int p2 = left.indexOf(45, 1);
            int start = defStart;
            int stop = defStop;
            if (p2 > 0) {
                start = MCast.toint(left.substring(0, p2), defStart);
                stop = MCast.toint(left.substring(p2 + 1), defStop);
            } else {
                stop = MCast.toint(left, defStop);
            }
            int interval = Math.max(1, Math.abs(MCast.toint(right, 0)));
            int len = (stop - start) / interval;
            int[] out = new int[len];
            for (int i = 0; i < len; ++i) {
                out[i] = start;
                start += interval;
            }
            return out;
        }
        p1 = def.indexOf(44);
        if (p1 > 0) {
            String[] parts = def.split(",");
            int[] out = new int[parts.length];
            boolean needOrder = false;
            for (int i = 0; i < out.length; ++i) {
                out[i] = MCast.toint(parts[i], 0);
                if (i == 0 || out[i - 1] < out[1]) continue;
                needOrder = true;
            }
            if (needOrder) {
                out = MCollection.order(out, false);
            }
            return out;
        }
        p1 = def.indexOf(45);
        if (p1 > 0) {
            int start = MCast.toint(def.substring(0, p1), defStart);
            int stop = MCast.toint(def.substring(p1 + 1), defStop);
            int len = stop - start;
            int[] out = new int[len];
            for (int i = 0; i < len; ++i) {
                out[i] = start++;
            }
            return out;
        }
        try {
            return new int[]{Integer.valueOf(def)};
        }
        catch (NumberFormatException e) {
            return new int[0];
        }
    }

    public static <E extends Enum<E>> E toEnum(Object value, E def) {
        if (value == null) {
            return def;
        }
        String str = String.valueOf(value).trim().toUpperCase();
        try {
            return Enum.valueOf(def.getDeclaringClass(), str);
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    public static String toReadableChar(char b) {
        if (b == '\r') {
            return "<BR>";
        }
        if (b == '\n') {
            return "<CR>";
        }
        if (b == '\t') {
            return "<TAB>";
        }
        if (b < ' ') {
            return "<" + MCast.toHex2String(b).toUpperCase() + ">";
        }
        return new String(new char[]{b});
    }

    public static String toBitsString(byte b) {
        StringBuilder out = new StringBuilder();
        int i = MMath.unsignetByteToInt(b);
        for (int j = 0; j < 8; ++j) {
            out.insert(0, i % 2 == 0 ? (char)'0' : '1');
            i /= 2;
        }
        return out.toString();
    }

    public static Object unserializeFromString(String value, ClassLoader cl) throws IOException, ClassNotFoundException {
        if (value == null) {
            return null;
        }
        byte[] bytes = MCast.fromBinaryString(value);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        MObjectInputStream ois = new MObjectInputStream((InputStream)bais, cl);
        return ois.readObject();
    }

    public static String serializeToString(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(value);
        oos.flush();
        oos.close();
        byte[] bytes = baos.toByteArray();
        return MCast.toBinaryString(bytes);
    }

    public static String toUnit(long p) {
        int unitId;
        boolean negative = false;
        if (p < 0L) {
            negative = true;
            p = -p;
        }
        for (unitId = UNIT_MAX; p > 100000L && unitId > 0; p /= 1000L, --unitId) {
        }
        if (unitId > 0 && p > 1000L) {
            double d = (double)p / 1000.0;
            return (negative ? "-" : "") + d + (unitId == UNIT_MAX ? "" : UNIT.values()[--unitId]);
        }
        return (negative ? "-" : "") + p + (unitId == UNIT_MAX ? "" : UNIT.values()[unitId]);
    }

    public static String toByteUnit(long p) {
        int unitId;
        boolean negative = false;
        if (p < 0L) {
            negative = true;
            p = -p;
        }
        for (unitId = UNIT_MAX; p > 100000L && unitId > 0; p /= 1024L, --unitId) {
        }
        if (unitId > 0 && p > 1000L) {
            double d = (double)p / 1000.0;
            return (negative ? "-" : "") + d + (unitId == UNIT_MAX ? "" : UNIT.values()[--unitId]);
        }
        return (negative ? "-" : "") + p + (unitId == UNIT_MAX ? "" : UNIT.values()[unitId]);
    }

    public static byte[] longToBytes(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    public static long bytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    static {
        MCast.addCaster(OBJECT_TO_BOOLEAN, true);
        MCast.addCaster(OBJECT_TO_INTEGER, true);
        MCast.addCaster(OBJECT_TO_BYTE, true);
        MCast.addCaster(OBJECT_TO_SHORT, true);
        MCast.addCaster(OBJECT_TO_LONG, true);
        MCast.addCaster(OBJECT_TO_DOUBLE, true);
        MCast.addCaster(OBJECT_TO_FLOAT, true);
        MCast.addCaster(OBJECT_TO_STRING, true);
        MCast.addCaster(OBJECT_TO_DATE, true);
        MCast.addCaster(OBJECT_TO_SQLDATE, true);
        MCast.addCaster(OBJECT_TO_CALENDAR, true);
        MCast.addCaster(DOUBLE_TO_STRING, true);
        MCast.addCaster(FLOAT_TO_STRING, true);
        MCast.addCaster(OBJECT_TO_BIGDECIMAL, true);
        MCast.addCaster(new ObjectToUUID(), true);
        UNIT_MAX = UNIT.values().length - 1;
    }

    private static enum UNIT {
        Z,
        E,
        P,
        T,
        G,
        M,
        K,
        X;

    }
}

