/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging.level;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.TrailLevelMapper;
import de.mhus.lib.logging.level.ThreadMapperConfig;

public class ThreadBasedMapper
implements TrailLevelMapper {
    private ThreadLocal<ThreadMapperConfig> map = new ThreadLocal();

    public void set(ThreadMapperConfig config) {
        this.map.set(config);
    }

    public void set(String config) {
        if (config == null || !config.startsWith("MAP")) {
            return;
        }
        ThreadMapperConfig c = new ThreadMapperConfig();
        c.doConfigure(config);
        this.set(c);
    }

    public void release() {
        this.map.remove();
    }

    public ThreadMapperConfig get() {
        ThreadMapperConfig config = this.map.get();
        if (config == null) {
            return null;
        }
        if (config.isTimedOut()) {
            this.release();
            return null;
        }
        return config;
    }

    @Override
    public Log.LEVEL map(Log log, Log.LEVEL level, Object ... msg) {
        ThreadMapperConfig config = this.get();
        if (config == null) {
            return level;
        }
        return config.map(log, level, msg);
    }

    @Override
    public String doSerializeTrail() {
        ThreadMapperConfig c = this.get();
        return c == null ? null : c.doSerialize();
    }

    @Override
    public void doConfigureTrail(String config) {
        if (MString.isEmpty(config)) {
            config = "MAP";
        }
        this.set(config);
    }

    @Override
    public void doResetTrail() {
        this.release();
    }

    @Override
    public boolean isLocalTrail() {
        ThreadMapperConfig c = this.get();
        return c == null ? false : c.isLocal();
    }

    @Override
    public void prepareMessage(Log log, StringBuilder msg) {
        ThreadMapperConfig config = this.map.get();
        if (config == null) {
            msg.append('(').append(Thread.currentThread().getId()).append(')');
        } else {
            config.prepareMessage(log, msg);
        }
    }

    @Override
    public String getTrailId() {
        ThreadMapperConfig config = this.map.get();
        if (config == null) {
            return String.valueOf(Thread.currentThread().getId());
        }
        return config.getTrailId();
    }

    public String toString() {
        return MSystem.toString(this, this.map.get());
    }

    @Override
    public void doResetAllTrails() {
        this.map = new ThreadLocal();
    }
}

