/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MDate;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogEngine;
import de.mhus.lib.core.logging.LogFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class FileLogger
extends Log {
    protected File file;
    private Log.LEVEL level = Log.LEVEL.INFO;
    private boolean printTime = true;
    private boolean traces = true;
    private PrintStream out;
    private long maxFileSize = 524288000L;
    private boolean autoFlush = false;
    private boolean rotate = true;

    public FileLogger(String name, File file) {
        this(name, file, Log.LEVEL.INFO);
    }

    public FileLogger(String name, File file, boolean autoFlush) {
        this(name, file, Log.LEVEL.INFO);
        this.autoFlush = autoFlush;
    }

    public FileLogger(String name, File file, Log.LEVEL level) {
        super(name);
        this.level = level;
        this.file = file;
    }

    public Log.LEVEL getLevel() {
        return this.level;
    }

    public FileLogger setLevel(Log.LEVEL level) {
        this.level = level;
        return this;
    }

    protected synchronized void print(String level, Object message, Throwable t) {
        if (!this.check()) {
            return;
        }
        this.out.println(String.valueOf(this.printTime()) + "," + level + "," + this.getInfo() + "," + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    protected String getInfo() {
        return this.getName();
    }

    protected synchronized boolean check() {
        this.doUpdateFile();
        if (this.file == null) {
            return false;
        }
        if (this.isRotate() && this.out != null && this.file.exists() && this.file.isFile() && this.file.length() > this.maxFileSize) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
        if (this.out == null) {
            if (this.file.exists() && this.file.isFile()) {
                this.rotate();
            }
            try {
                this.out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.file)));
            }
            catch (FileNotFoundException e) {
                MApi.dirtyLog(e);
            }
        }
        return this.out != null;
    }

    protected void doUpdateFile() {
    }

    protected void rotate() {
        if (!this.isRotate()) {
            return;
        }
        File oldFile = this.file;
        this.doUpdateFile();
        if (this.file == null) {
            if (oldFile != null && this.out != null) {
                this.out.close();
                this.out = null;
            }
            return;
        }
        if (this.file.exists() && this.file.isFile()) {
            this.file.renameTo(new File(this.file.getParentFile(), String.valueOf(MDate.toFileFormat(new Date())) + "." + this.file.getName()));
        }
    }

    public String printTime() {
        if (this.printTime) {
            return MCast.toString(new Date());
        }
        return "";
    }

    public boolean isPrintTime() {
        return this.printTime;
    }

    public FileLogger setPrintTime(boolean printTime) {
        this.printTime = printTime;
        return this;
    }

    public boolean isTraces() {
        return this.traces;
    }

    public FileLogger setTraces(boolean traces) {
        this.traces = traces;
        return this;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @Override
    public void update() {
        this.engine = new MyEngine(this.getName());
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.file = null;
            this.out = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean isRotate() {
        return this.rotate;
    }

    public FileLogger setRotate(boolean rotate) {
        this.rotate = rotate;
        return this;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public FileLogger setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
        return this;
    }

    private class MyEngine
    extends LogEngine {
        public MyEngine(String name) {
            super(name);
        }

        @Override
        public void debug(Object message) {
            if (!this.isDebugEnabled()) {
                return;
            }
            FileLogger.this.print("DEBUG", message, null);
        }

        @Override
        public void debug(Object message, Throwable t) {
            if (!this.isDebugEnabled()) {
                return;
            }
            FileLogger.this.print("DEBUG", message, t);
        }

        @Override
        public void error(Object message) {
            if (!this.isErrorEnabled()) {
                return;
            }
            FileLogger.this.print("ERROR", message, null);
        }

        @Override
        public void error(Object message, Throwable t) {
            if (!this.isErrorEnabled()) {
                return;
            }
            FileLogger.this.print("ERROR", message, t);
        }

        @Override
        public void fatal(Object message) {
            if (!this.isFatalEnabled()) {
                return;
            }
            FileLogger.this.print("FATAL", message, null);
        }

        @Override
        public void fatal(Object message, Throwable t) {
            if (!this.isFatalEnabled()) {
                return;
            }
            FileLogger.this.print("FATAL", message, t);
        }

        @Override
        public void info(Object message) {
            if (!this.isInfoEnabled()) {
                return;
            }
            FileLogger.this.print("INFO", message, null);
        }

        @Override
        public void info(Object message, Throwable t) {
            if (!this.isInfoEnabled()) {
                return;
            }
            FileLogger.this.print("INFO", message, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return FileLogger.this.getLevel().ordinal() <= Log.LEVEL.DEBUG.ordinal();
        }

        @Override
        public boolean isErrorEnabled() {
            return FileLogger.this.getLevel().ordinal() <= Log.LEVEL.ERROR.ordinal();
        }

        @Override
        public boolean isFatalEnabled() {
            return FileLogger.this.getLevel().ordinal() <= Log.LEVEL.FATAL.ordinal();
        }

        @Override
        public boolean isInfoEnabled() {
            return FileLogger.this.getLevel().ordinal() <= Log.LEVEL.INFO.ordinal();
        }

        @Override
        public boolean isTraceEnabled() {
            return FileLogger.this.getLevel().ordinal() <= Log.LEVEL.TRACE.ordinal();
        }

        @Override
        public boolean isWarnEnabled() {
            return FileLogger.this.getLevel().ordinal() <= Log.LEVEL.WARN.ordinal();
        }

        @Override
        public void trace(Object message) {
            if (this.isTraceEnabled()) {
                FileLogger.this.print("TRACE", message, null);
            }
        }

        @Override
        public void trace(Object message, Throwable t) {
            if (!this.isTraceEnabled()) {
                return;
            }
            FileLogger.this.print("TRACE", message, t);
        }

        @Override
        public void warn(Object message) {
            if (!this.isWarnEnabled()) {
                return;
            }
            FileLogger.this.print("WARN", message, null);
        }

        @Override
        public void warn(Object message, Throwable t) {
            if (!this.isWarnEnabled()) {
                return;
            }
            FileLogger.this.print("WARN", message, t);
        }

        @Override
        public void doInitialize(LogFactory logFactory) {
        }

        @Override
        public void close() {
        }
    }
}

