/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.core.util.MNls;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.UiComponent;

public class ModelDataSource
implements DataSource {
    private DataSource next;

    public ModelDataSource() {
    }

    public ModelDataSource(DataSource next) {
        this.setNext(next);
    }

    @Override
    public boolean getBoolean(UiComponent component, String name, boolean def) {
        if (this.isHandled(name) && component.getConfig().isProperty(name)) {
            return component.getConfig().getBoolean(name, def);
        }
        if (this.next != null) {
            return this.next.getBoolean(component, name, def);
        }
        return def;
    }

    private boolean isHandled(String name) {
        switch (name) {
            case "description": 
            case "enabled": 
            case "visible": 
            case "caption": 
            case "editable": {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getInt(UiComponent component, String name, int def) {
        if (this.isHandled(name) && component.getConfig().isProperty(name)) {
            return component.getConfig().getInt(name, def);
        }
        if (this.next != null) {
            return this.next.getInt(component, name, def);
        }
        return def;
    }

    @Override
    public String getString(UiComponent component, String name, String def) {
        if (this.isHandled(name) && component.getConfig().isProperty(name)) {
            String expression = component.getConfig().getString(name, def);
            return MNls.find(component.getForm(), expression);
        }
        if (this.next != null) {
            return this.next.getString(component, name, def);
        }
        return def;
    }

    @Override
    public Object getObject(UiComponent component, String name, Object def) {
        if (this.isHandled(name) && component.getConfig().isProperty(name)) {
            return component.getConfig().getString(name, def != null ? String.valueOf(def) : null);
        }
        if (this.next != null) {
            return this.next.getObject(component, name, def);
        }
        return def;
    }

    @Override
    public void setObject(UiComponent component, String name, Object value) throws Exception {
        if (this.next != null) {
            this.next.setObject(component, name, value);
        }
    }

    @Override
    public DataSource getNext() {
        return this.next;
    }

    public void setNext(DataSource chain) {
        this.next = chain;
    }
}

