/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.vault.MVault;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.core.vault.VaultSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;

public class DefaultVault
extends MObject
implements MVault {
    private HashMap<String, VaultSource> sources = new HashMap();
    private MVault parent;

    public DefaultVault() {
    }

    public DefaultVault(MVault parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSource(VaultSource source) {
        if (source == null) {
            return;
        }
        HashMap<String, VaultSource> hashMap = this.sources;
        synchronized (hashMap) {
            this.sources.put(source.getName(), source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSource(String sourceName) {
        if (sourceName == null) {
            return;
        }
        HashMap<String, VaultSource> hashMap = this.sources;
        synchronized (hashMap) {
            this.sources.remove(sourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSourceNames() {
        if (this.parent != null) {
            String[] parentNames = this.parent.getSourceNames();
            HashMap<String, VaultSource> hashMap = this.sources;
            synchronized (hashMap) {
                String name;
                String[] out = new String[parentNames.length + this.sources.size()];
                int cnt = 0;
                Iterator<String> iterator = this.sources.keySet().iterator();
                while (iterator.hasNext()) {
                    out[cnt] = name = iterator.next();
                    ++cnt;
                }
                String[] stringArray = parentNames;
                int n = parentNames.length;
                int n2 = 0;
                while (n2 < n) {
                    out[cnt] = name = stringArray[n2];
                    ++cnt;
                    ++n2;
                }
                return out;
            }
        }
        HashMap<String, VaultSource> hashMap = this.sources;
        synchronized (hashMap) {
            return this.sources.keySet().toArray(new String[this.sources.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultSource getSource(String name) {
        HashMap<String, VaultSource> hashMap = this.sources;
        synchronized (hashMap) {
            VaultSource ret = this.sources.get(name);
            if (ret == null && this.parent != null) {
                return this.parent.getSource(name);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultEntry getEntry(UUID id) {
        HashMap<String, VaultSource> hashMap = this.sources;
        synchronized (hashMap) {
            for (VaultSource source : this.sources.values()) {
                VaultEntry res = source.getEntry(id);
                if (res == null) continue;
                return res;
            }
        }
        if (this.parent != null) {
            return this.parent.getEntry(id);
        }
        return null;
    }
}

