/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util.lambda;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.errors.NotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;

public class LambdaUtil {
    public static boolean debugOut = false;
    private static final Instrumentation instrumentation = ByteBuddyAgent.install();

    public static String getDoubleUnaryOperatorName(DoubleUnaryOperator lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getLongUnaryOperatorName(LongUnaryOperator lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getIntUnaryOperatorName(IntUnaryOperator lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T> String getToLongFunctionName(ToLongFunction<T> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T> String getToDoubleFunctionName(ToDoubleFunction<T> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T> String getToIntFunctionName(ToIntFunction<T> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T, U> String getBiPredicateName(BiPredicate<T, U> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getLongPredicateName(LongPredicate lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getDoublePredicateName(DoublePredicate lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getIntPredicateName(IntPredicate lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <R> String getDoubleFunctionName(DoubleFunction<R> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <R> String getLongFunctionName(LongFunction<R> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <R> String getIntFunctionName(IntFunction<R> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getLongSupplierName(LongSupplier lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getIntSupplierName(IntSupplier lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getBooleanSupplierName(BooleanSupplier lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T> String getPredicateName(Predicate<T> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T> String getBinaryOperatorName(BinaryOperator<T> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T, U, R> String getBiFunctionName(BiFunction<T, U, R> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T, R> String getBiConsumerName(BiConsumer<T, R> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T> String getConsumerName(Consumer<T> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static String getSupplierName(Supplier<?> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    public static <T> String getFunctionName(Function<T, ?> lambda) throws NotFoundException {
        return LambdaUtil.getName(lambda);
    }

    private static String getName(Object lambda) throws NotFoundException {
        byte[] bc = null;
        try {
            bc = LambdaUtil.getByteCodeOf(lambda.getClass());
            if (debugOut) {
                System.out.println(MString.toHexDump(bc, 20));
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < bc.length) {
                if (bc[i] < 32 || bc[i] > 128) {
                    sb.append('|');
                } else {
                    sb.append((char)bc[i]);
                }
                ++i;
            }
            String code = sb.toString();
            if (code.indexOf("java/lang/invoke/LambdaForm$Hidden;") > 0) {
                return LambdaUtil.inspect8_b132(lambda, bc, code);
            }
            if (code.indexOf("&(Ljava/lang/Object;)Ljava/lang/Object;") > 0) {
                return LambdaUtil.inspect8_121(lambda, bc, code);
            }
        }
        catch (IOException e) {
            throw new NotFoundException(new Object[]{"method in lambda not found", MSystem.getJavaVersion(), lambda, MString.toHexDump(bc, 20), e});
        }
        throw new NotFoundException(new Object[]{"method in lambda not found", MSystem.getJavaVersion(), MString.toHexDump(bc, 20), lambda});
    }

    private static String inspect8_121(Object lambda, byte[] bc, String code) throws NotFoundException {
        int pos = code.indexOf("&(Ljava/lang/Object;)Ljava/lang/Object;") + 40;
        code = code.substring(pos);
        String[] parts = code.split("\\|");
        String last = null;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if ((p = p.trim()).length() != 0) {
                if (p.startsWith("()") && last != null) {
                    return last;
                }
                if (p.indexOf(59) == -1 && p.indexOf(47) == -1) {
                    last = p;
                }
            }
            ++n2;
        }
        throw new NotFoundException(new Object[]{"method in lambda not found", MSystem.getJavaVersion(), MString.toHexDump(bc, 20), lambda});
    }

    private static String inspect8_b132(Object lambda, byte[] bc, String code) throws NotFoundException {
        String[] parts = code.split("\\|");
        boolean hiddenFound = false;
        boolean ignoreFound = false;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if ((p = p.trim()).indexOf("java/lang/invoke/LambdaForm$Hidden;") > 0) {
                hiddenFound = true;
            } else if (hiddenFound) {
                if (!ignoreFound && (p.equals("intValue") || p.equals("longValue") || p.equals("doubleValue") || p.equals("booleanValue") || p.equals("floatValue") || p.equals("shortValue") || p.equals("byteValue") || p.equals("charValue"))) {
                    ignoreFound = true;
                } else if (p.length() > 1 && p.indexOf(47) < 0 && p.indexOf(36) < 0 && p.indexOf(60) < 0 && p.indexOf(40) < 0 && p.indexOf(91) < 0) {
                    return p;
                }
            }
            ++n2;
        }
        throw new NotFoundException(new Object[]{"method in lambda not found", MSystem.getJavaVersion(), MString.toHexDump(bc, 20), lambda});
    }

    static byte[] getByteCodeOf(Class<?> c) throws IOException {
        ClassFileLocator locator = ClassFileLocator.AgentBased.of((Instrumentation)instrumentation, c);
        TypeDescription.ForLoadedType desc = new TypeDescription.ForLoadedType(c);
        ClassFileLocator.Resolution resolution = locator.locate(desc.getName());
        return resolution.resolve();
    }
}

