/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.VersionRange;

public class Version
implements Comparable<Version> {
    public static final Version V_0_0_0 = new Version("0.0.0");
    public static final Version V_1_0_0 = new Version("1.0.0");
    private String original;
    private long[] versions;
    private VersionRange range;

    public Version(String in) {
        if (in == null) {
            in = "0.0.0";
        }
        this.original = in;
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c != '.' && (c < '0' || c > '9')) {
                in = in.substring(0, i);
                break;
            }
            ++i;
        }
        String[] parts = in.split("\\.");
        this.versions = new long[parts.length];
        int i2 = 0;
        while (i2 < parts.length) {
            this.versions[i2] = MCast.tolong(parts[i2], 0L);
            ++i2;
        }
    }

    public int size() {
        if (this.versions == null) {
            return 0;
        }
        return this.versions.length;
    }

    public long getVersion(int index) {
        return this.versions[index];
    }

    public String toString() {
        return MString.join(this.versions, '.');
    }

    public boolean equals(Object in) {
        if (in == null) {
            return false;
        }
        if (in instanceof String) {
            in = new Version((String)in);
        }
        if (in instanceof Version) {
            Version v = (Version)in;
            if (v.size() != this.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (v.getVersion(i) != this.getVersion(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Version o) {
        int len = Math.min(this.size(), o.size());
        int i = 0;
        while (i < len) {
            long v;
            long ov = o.getVersion(i);
            if (ov < (v = this.getVersion(i))) {
                return 1;
            }
            if (ov > v) {
                return -1;
            }
            ++i;
        }
        if (this.size() > len) {
            return 1;
        }
        if (o.size() > len) {
            return -1;
        }
        return 0;
    }

    public VersionRange toRange() {
        if (this.range == null) {
            this.range = new VersionRange(this.toString());
        }
        return this.range;
    }

    public String getOriginal() {
        return this.original;
    }
}

