/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.core.util.TableColumn;
import de.mhus.lib.core.util.TableRow;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Table
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String name;
    LinkedList<TableColumn> columns = new LinkedList();
    HashMap<String, Integer> columnsIndex = new HashMap();
    LinkedList<TableRow> rows = new LinkedList();

    public Table() {
    }

    public Table(ResultSet res) throws SQLException {
        ResultSetMetaData meta = res.getMetaData();
        int count = meta.getColumnCount();
        int i = 0;
        while (i < count) {
            this.addHeader(meta.getColumnName(i + 1), meta.getColumnTypeName(i + 1));
            ++i;
        }
        while (res.next()) {
            TableRow row = new TableRow();
            row.setTable(this);
            int i2 = 0;
            while (i2 < count) {
                try {
                    row.appendData(res.getObject(i2 + 1));
                }
                catch (Throwable t) {
                    MLogUtil.log().t(t);
                    row.appendData(new Object[]{null});
                }
                ++i2;
            }
            this.getRows().add(row);
        }
        res.close();
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public TableColumn addHeader(String name, Class<?> type) {
        return this.addHeader(name, type.getCanonicalName());
    }

    public TableColumn addHeader(String name, String type) {
        TableColumn col = new TableColumn();
        col.setName(name);
        col.setType(type);
        this.columnsIndex.put(name, this.columns.size());
        this.columns.add(col);
        return col;
    }

    public TableRow addRow(Object ... data) {
        TableRow row = new TableRow();
        row.setTable(this);
        row.setData(data);
        this.rows.add(row);
        return row;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.name == null) {
            this.name = "";
        }
        out.writeUTF(this.name);
        out.writeInt(this.columns.size());
        for (TableColumn col : this.columns) {
            out.writeObject(col);
        }
        out.writeInt(this.rows.size());
        for (TableRow row : this.rows) {
            out.writeObject(row);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        int size = in.readInt();
        this.columns = new LinkedList();
        this.columnsIndex = new HashMap();
        int i = 0;
        while (i < size) {
            TableColumn col = (TableColumn)in.readObject();
            this.columnsIndex.put(col.getName(), this.columns.size());
            this.columns.add(col);
            ++i;
        }
        size = in.readInt();
        this.rows = new LinkedList();
        i = 0;
        while (i < size) {
            TableRow row = (TableRow)in.readObject();
            row.setTable(this);
            this.rows.add(row);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getColumnIndex(String name) {
        Integer ret = this.columnsIndex.get(name);
        return ret == null ? -1 : ret;
    }

    public String toString() {
        return String.valueOf(this.columns.toString()) + this.rows.toString();
    }

    public int getColumnSize() {
        return this.columns.size();
    }

    public int getRowSize() {
        return this.rows.size();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.name == null) {
            this.name = "";
        }
        out.writeUTF(this.name);
        out.writeInt(this.columns.size());
        for (TableColumn col : this.columns) {
            out.writeObject(col);
        }
        out.writeInt(this.rows.size());
        for (TableRow row : this.rows) {
            out.writeObject(row);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        int size = in.readInt();
        this.columns = new LinkedList();
        this.columnsIndex = new HashMap();
        int i = 0;
        while (i < size) {
            TableColumn col = (TableColumn)in.readObject();
            this.columnsIndex.put(col.getName(), this.columns.size());
            this.columns.add(col);
            ++i;
        }
        size = in.readInt();
        this.rows = new LinkedList();
        i = 0;
        while (i < size) {
            TableRow row = (TableRow)in.readObject();
            row.setTable(this);
            this.rows.add(row);
            ++i;
        }
    }
}

