/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.IReadProperties;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.errors.MException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ParameterDefinition {
    private static Log log = Log.getLog(ParameterDefinition.class);
    private String name;
    private String type;
    private String def = null;
    private boolean mandatory;
    private String mapping;
    private String format;
    private IReadProperties properties;

    public ParameterDefinition(String line) {
        if (!MString.isIndex(line, ',')) {
            this.name = line;
            if (this.name.startsWith("*")) {
                this.mandatory = true;
                this.name = this.name.substring(1);
            }
            this.type = "string";
            return;
        }
        this.name = MString.beforeIndex(line, ',');
        line = MString.afterIndex(line, ',');
        this.properties = MProperties.explodeToMProperties(line.split(","), ':');
        if (this.name.startsWith("*")) {
            this.mandatory = true;
            this.name = this.name.substring(1);
        }
        this.type = this.properties.getString("type", "");
        this.mandatory = this.properties.getBoolean("mandatory", this.mandatory);
        this.def = this.properties.getString("default", null);
        this.mapping = this.properties.getString("mapping", null);
        this.format = this.properties.getString("format", null);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDef() {
        return this.def;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public String getMapping() {
        return this.mapping;
    }

    public String getFormat() {
        return this.format;
    }

    public IReadProperties getProperties() {
        return this.properties;
    }

    public Object transform(Object object) throws MException {
        switch (this.type) {
            case "int": 
            case "integer": {
                return MCast.toint(object, MCast.toint(this.def, 0));
            }
            case "long": {
                return MCast.tolong(object, MCast.tolong(this.def, 0L));
            }
            case "bool": 
            case "boolean": {
                return MCast.toboolean(object, MCast.toboolean(this.def, false));
            }
            case "datestring": {
                Date date = MCast.toDate(object, MCast.toDate(this.def, null));
                if (date == null) {
                    return "";
                }
                return new SimpleDateFormat(this.format).format(date);
            }
            case "date": {
                Date date = MCast.toDate(object, MCast.toDate(this.def, null));
                if (date == null) {
                    return "";
                }
                return date;
            }
            case "enum": {
                String[] parts = this.def.split(",");
                String val = String.valueOf(object).toLowerCase();
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (val.equals(p.toLowerCase())) {
                        return p;
                    }
                    ++n2;
                }
                if (this.isMandatory()) {
                    throw new MException(new Object[]{"field is mandatory", this.name});
                }
                return "";
            }
            case "string": 
            case "text": {
                return String.valueOf(object);
            }
        }
        log.d("Unknown Type", this.name, this.type);
        return object;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.type;
    }
}

