/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.MutableUri;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;

public abstract class MUri
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static final String SCHEME_FTP = "ftp";
    public static final String SCHEME_FILE = "file";
    public static final String SCHEME_SFPT = "sftp";

    /*
     * Unable to fully structure code
     */
    public static String decode(String _in) {
        if (_in == null) {
            return "";
        }
        try {
            return URLDecoder.decode(_in, "UTF-8");
        }
        catch (UnsupportedEncodingException var1_1) {
            sb = new StringBuilder();
            mode = 0;
            buffer = 0;
            i = 0;
            ** while (i < _in.length())
        }
lbl-1000:
        // 1 sources

        {
            c = _in.charAt(i);
            if (mode == 0) {
                if (c == '%') {
                    mode = 1;
                    buffer = 0;
                } else if (c == '+') {
                    sb.append(' ');
                } else {
                    sb.append(c);
                }
            } else if (mode == 1) {
                if (c >= '0' && c <= '9') {
                    buffer = c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    buffer = c + 10 - 65;
                } else if (c >= 'a' && c <= 'f') {
                    buffer = c + 10 - 97;
                }
                mode = 2;
            } else if (mode == 2) {
                buffer *= 16;
                if (c >= '0' && c <= '9') {
                    buffer += c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    buffer += c + 10 - 65;
                } else if (c >= 'a' && c <= 'f') {
                    buffer += c + 10 - 97;
                }
                sb.append((char)buffer);
                mode = 0;
            }
            ++i;
            continue;
        }
lbl50:
        // 1 sources

        return sb.toString();
    }

    public static String encode(String _in) {
        if (_in == null) {
            return "";
        }
        try {
            return URLEncoder.encode(_in, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return MUri.encodeNoUTF8(_in);
        }
    }

    public static String encodeNoUTF8(String _in) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < _in.length()) {
            char c = _in.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ',' || c == '.')) {
                MUri.encodeNoUTF8(sb, c);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String encode(char c) {
        StringBuilder sb = new StringBuilder();
        MUri.encodeNoUTF8(sb, c);
        return sb.toString();
    }

    public static void encodeNoUTF8(StringBuilder sb, char c) {
        if (c == ' ') {
            sb.append('+');
            return;
        }
        sb.append('%');
        int buffer = 0;
        char cc = c;
        buffer = cc / 16;
        if (buffer < 10) {
            sb.append((char)(48 + buffer));
        } else {
            sb.append((char)(55 + buffer));
        }
        buffer = cc % 16;
        if (buffer < 10) {
            sb.append((char)(48 + buffer));
        } else {
            sb.append((char)(55 + buffer));
        }
    }

    public static String implodeArray(String ... in) {
        if (in == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        String[] stringArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (!first) {
                sb.append('&');
            }
            sb.append(MUri.encode(i));
            first = false;
            ++n2;
        }
        return sb.toString();
    }

    public static String implodeKeyValues(String ... in) {
        if (in == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean key = true;
        String[] stringArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (!first && key) {
                sb.append('&');
            }
            sb.append(MUri.encode(i));
            first = false;
            if (key) {
                sb.append('=');
                key = false;
            } else {
                key = true;
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String[] explodeArray(String in) {
        if (in == null || in.length() == 0) {
            return new String[0];
        }
        String[] out = in.split("&");
        int i = 0;
        while (i < out.length) {
            out[i] = MUri.decode(out[i]);
            ++i;
        }
        return out;
    }

    public static Map<String, String> explode(String _in) {
        if (_in == null) {
            return new TreeMap<String, String>();
        }
        TreeMap<String, String> out = new TreeMap<String, String>();
        String[] obj = _in.split("&");
        int i = 0;
        while (i < obj.length) {
            String[] kv = obj[i].split("=");
            if (kv.length == 2) {
                if (kv[1] == null) {
                    kv[1] = "";
                }
                out.put(MUri.decode(kv[0]), MUri.decode(kv[1]));
            } else if (kv.length == 1) {
                out.put(MUri.decode(kv[0]), "");
            }
            ++i;
        }
        return out;
    }

    public static String implode(Map<String, String> _in) {
        if (_in == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : _in.keySet()) {
            String value = _in.get(key);
            if (value == null) continue;
            if (!first) {
                sb.append('&');
            }
            sb.append(MUri.encode(key));
            sb.append('=');
            sb.append(MUri.encode(value));
            first = false;
        }
        return sb.toString();
    }

    public static String implode(IProperties _in) {
        if (_in == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : _in.keys()) {
            String value = _in.getString(key, null);
            if (value == null) continue;
            if (!first) {
                sb.append('&');
            }
            sb.append(MUri.encode(key));
            sb.append('=');
            sb.append(MUri.encode(value));
            first = false;
        }
        return sb.toString();
    }

    public static void setParameterValue(String url, String name, String value) {
        name = String.valueOf(MUri.encode(name)) + "=";
        value = MUri.encode(value);
        int pos = url.indexOf("&" + name);
        if (pos < 0) {
            pos = url.indexOf("?" + name);
        }
        if (pos < 0) {
            url = url.contains("?") ? String.valueOf(url) + "&" : String.valueOf(url) + "?";
            url = String.valueOf(url) + name + value;
        } else {
            int pos2 = url.indexOf("&", pos + 1);
            url = pos2 < 0 ? String.valueOf(url.substring(0, pos + 1 + name.length())) + value : String.valueOf(url.substring(0, pos + 1 + name.length())) + value + url.substring(pos2);
        }
    }

    public static MUri toUri(String path) {
        return new MutableUri(path);
    }

    public static MUri toUri(File file) {
        return new MutableUri("file:" + file.getAbsolutePath());
    }

    public abstract String getScheme();

    public abstract String getLocation();

    public abstract String getUsername();

    public abstract String getPassword();

    public abstract String[] getParams();

    public abstract Map<String, String> getQuery();

    public abstract String getFragment();

    public abstract String getPath();

    public abstract String[] getPathParts();

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.getScheme() != null) {
            out.append(this.getScheme()).append(':');
        }
        if (this.getUsername() != null) {
            out.append("//").append(this.getUsername());
            if (this.getPassword() != null) {
                out.append(':').append(this.getPassword());
            }
            out.append("@");
            if (this.getLocation() != null) {
                out.append(this.getLocation());
            }
        } else if (this.getLocation() != null) {
            out.append("//").append(this.getLocation());
        }
        if (MString.isSet(this.getPath()) && this.getLocation() != null && !this.getPath().startsWith("/")) {
            out.append('/');
        }
        if (MString.isSet(this.getPath())) {
            out.append(this.getPath());
        }
        if (this.getParams() != null) {
            String[] stringArray = this.getParams();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                out.append(';').append(MUri.encode(p));
                ++n2;
            }
        }
        if (this.getQuery() != null) {
            out.append('?');
            boolean first = true;
            for (Map.Entry<String, String> entry : this.getQuery().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    out.append('&');
                }
                out.append(MUri.encode(entry.getKey())).append('=').append(MUri.encode(entry.getValue()));
            }
        }
        if (this.getFragment() != null) {
            out.append('#').append(this.getFragment());
        }
        return out.toString();
    }

    public static class Query
    extends TreeMap<String, String> {
        private static final long serialVersionUID = -1L;

        @Override
        public void put(String _key, int _value) {
            this.put(_key, MCast.toString(_value));
        }

        public int getInt(String _key, int _def) {
            String v = (String)this.get(_key);
            if (v == null) {
                return _def;
            }
            return MCast.toint(v, 0);
        }

        public int getInt(String _key) {
            return this.getInt(_key, -1);
        }

        @Override
        public String toString() {
            return MUri.implode(this);
        }
    }
}

