/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.directory.ClassLoaderResourceProvider;
import de.mhus.lib.core.directory.MResourceProvider;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class MNlsFactory
extends MNlsBundle {
    private ResourceNode<?> config;

    public MNlsFactory() {
        this((ResourceNode<?>)null);
    }

    public MNlsFactory(ResourceNode<?> config) {
        this.config = config;
    }

    public MNls create(Object owner) {
        return this.load(null, null, MNlsFactory.toResourceName(owner), null);
    }

    public MNls load(Class<?> owner) {
        return this.load(null, owner, null, null);
    }

    public static String toResourceName(Object owner) {
        if (owner == null) {
            return null;
        }
        if (owner instanceof String) {
            return (String)owner;
        }
        return MSystem.getClassName(owner).replace('.', '/');
    }

    public MNls load(Class<?> owner, Locale locale) {
        return this.load(null, owner, null, locale == null ? null : locale.toString());
    }

    public MNls load(MResourceProvider<?> res, Class<?> owner, String resourceName, String locale) {
        return this.load(res, owner, resourceName, locale, true);
    }

    public MNls load(MResourceProvider<?> res, Class<?> owner, String resourceName, String locale, boolean searchAlternatives) {
        return this.load(res, owner, resourceName, locale, searchAlternatives, 0);
    }

    protected MNls load(MResourceProvider<?> res, Class<?> owner, String resourceName, String locale, boolean searchAlternatives, int level) {
        if (level > 50) {
            return null;
        }
        try {
            if (resourceName == null) {
                resourceName = owner.getCanonicalName() != null ? owner.getCanonicalName().replace('.', '/') : owner.getEnclosingClass().getCanonicalName().replace('.', '/');
            }
            if (res == null) {
                res = this.findResourceProvider(owner);
            }
            if (locale == null) {
                locale = this.getDefaultLocale();
            }
            InputStream is = null;
            Properties properties = new Properties();
            is = ((ResourceNode)res.getResourceByPath(String.valueOf(locale.toString()) + "/" + resourceName + ".properties")).getInputStream();
            String prefix = this.getResourcePrefix();
            if (searchAlternatives) {
                if (prefix != null && is == null) {
                    is = ((ResourceNode)res.getResourceByPath(String.valueOf(prefix) + "/" + this.getDefaultLocale() + "/" + resourceName + ".properties")).getInputStream();
                }
                if (is == null) {
                    is = ((ResourceNode)res.getResourceByPath(String.valueOf(this.getDefaultLocale()) + "/" + resourceName + ".properties")).getInputStream();
                }
                if (prefix != null && is == null) {
                    is = ((ResourceNode)res.getResourceByPath(String.valueOf(prefix) + "/" + resourceName + ".properties")).getInputStream();
                }
                if (is == null) {
                    is = ((ResourceNode)res.getResourceByPath(String.valueOf(resourceName) + ".properties")).getInputStream();
                }
            }
            if (is != null) {
                this.log().t("Load Resource", resourceName, locale);
                InputStreamReader r = new InputStreamReader(is, "UTF-8");
                properties.load(r);
                is.close();
                String[] stringArray = properties.getProperty(".include", "").split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String include = stringArray[n2];
                    MNls parent = this.load(null, null, include = include.trim(), locale, false, level + 1);
                    if (parent != null) {
                        for (Map.Entry<Object, Object> entry : parent.properties.entrySet()) {
                            if (properties.containsKey(entry.getKey())) continue;
                            properties.put(entry.getKey(), entry.getValue());
                        }
                    }
                    ++n2;
                }
                return new MNls(properties, "");
            }
            this.log().d("Resource not found", resourceName, locale);
        }
        catch (Throwable e) {
            this.log().i(e);
        }
        return new MNls();
    }

    protected String getResourcePrefix() {
        return null;
    }

    protected MResourceProvider<?> findResourceProvider(Class<?> owner) {
        if (owner != null) {
            return new ClassLoaderResourceProvider(owner.getClassLoader());
        }
        return new ClassLoaderResourceProvider();
    }

    public String getDefaultLocale() {
        return Locale.getDefault().toString();
    }

    public MNls load(InputStream is) {
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            this.log().i(e);
        }
        return new MNls(properties, "");
    }

    public static MNlsFactory lookup(Object owner) {
        return MApi.lookup(MNlsFactory.class);
    }

    @Override
    public MNls createNls(String locale) {
        return this.load(null, null, this.getPath(), locale, false);
    }

    public static /* bridge */ /* synthetic */ MNlsBundle lookup(Object object) {
        return MNlsFactory.lookup(object);
    }
}

