/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.system;

import de.mhus.lib.core.MHousekeeper;
import de.mhus.lib.core.MHousekeeperTask;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MTimer;
import de.mhus.lib.core.MTimerTask;
import java.lang.ref.WeakReference;
import java.util.TimerTask;

public class DefaultHousekeeper
extends MLog
implements MHousekeeper {
    private MTimer timer;

    public DefaultHousekeeper() {
        this.log().t("new default housekeeper");
        this.timer = new MTimer(true);
    }

    @Override
    public void register(MHousekeeperTask task, long sleep) {
        this.timer.schedule((TimerTask)new MyTimerTask(task), sleep, sleep);
    }

    public void finalize() {
        this.log().t("finalize");
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    private class MyTimerTask
    extends MTimerTask {
        private WeakReference<TimerTask> refWeak;
        private TimerTask ref;

        public MyTimerTask(TimerTask task) {
            this.refWeak = new WeakReference<TimerTask>(task);
        }

        @Override
        public void doit() throws Exception {
            TimerTask r = null;
            r = this.refWeak != null ? (TimerTask)this.refWeak.get() : this.ref;
            if (r == null) {
                this.cancel();
                return;
            }
            if (r instanceof MTimerTask && ((MTimerTask)r).isCanceled()) {
                this.cancel();
                return;
            }
            r.run();
        }
    }
}

