/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.core.MThread;
import de.mhus.lib.core.strategy.ExecuteStrategy;
import de.mhus.lib.core.strategy.NotSuccessful;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationDescription;
import de.mhus.lib.core.strategy.OperationResult;
import de.mhus.lib.core.strategy.TaskContext;
import java.util.concurrent.TimeoutException;

public class WaitExecuteStrategy
extends ExecuteStrategy {
    private Operation executable;
    private long waitTime;
    private long timeout;

    @Override
    protected OperationResult doExecute2(TaskContext context) throws Exception {
        if (this.executable == null) {
            return new NotSuccessful(this, "executable not found", -10L);
        }
        try {
            long cnt = this.timeout;
            while (!this.executable.setBusy(this)) {
                MThread.sleep(this.waitTime);
                if (cnt <= 0L || (cnt -= this.waitTime) > 0L) continue;
                throw new TimeoutException("timeout");
            }
            if (this.executable == null) {
                NotSuccessful notSuccessful = new NotSuccessful(this, "executable not found", -10L);
                return notSuccessful;
            }
            OperationResult operationResult = this.executable.doExecute(context);
            return operationResult;
        }
        finally {
            if (this.executable != null) {
                this.executable.releaseBusy(this);
            }
        }
    }

    @Override
    public Operation getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(Operation executable) {
        this.executable = executable;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public OperationDescription getDescription() {
        if (this.executable == null) {
            return null;
        }
        return this.executable.getDescription();
    }

    @Override
    public boolean canExecute(TaskContext context) {
        if (this.executable == null) {
            return false;
        }
        return this.executable.canExecute(context);
    }

    @Override
    public boolean hasAccess() {
        if (this.executable == null) {
            return false;
        }
        return this.executable.hasAccess();
    }

    @Override
    protected OperationDescription createDescription() {
        return null;
    }
}

