/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.PrintWriterLog;
import de.mhus.lib.core.strategy.TaskContext;
import java.io.PrintWriter;

public class PrintWriterTaskContext
implements TaskContext {
    private MProperties attributes = new MProperties();
    private IConfig config;
    private boolean testOnly = false;
    private PrintWriter writer;
    private long estimated;
    private long step;
    private Log log = null;
    private String errorMessage;

    public PrintWriterTaskContext(String name, PrintWriter writer, IConfig config, boolean testOnly) {
        this.log = new PrintWriterLog(name, writer);
        this.writer = writer;
        this.config = config;
        this.testOnly = testOnly;
    }

    public PrintWriterTaskContext(PrintWriterLog log, IConfig config, boolean testOnly) {
        this.log = log;
        this.writer = log.getWriter();
        this.config = config;
        this.testOnly = testOnly;
    }

    @Override
    public void println() {
        this.writer.println();
    }

    @Override
    public void println(Object ... out) {
        Object[] objectArray = out;
        int n = out.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.writer.print(o);
            ++n2;
        }
        this.writer.println();
    }

    @Override
    public void print(Object ... out) {
        Object[] objectArray = out;
        int n = out.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.writer.print(o);
            ++n2;
        }
    }

    @Override
    public Log log() {
        return this.log;
    }

    @Override
    public void setSteps(long steps) {
        this.estimated = steps;
    }

    @Override
    public void setStep(long step) {
        this.step = step;
    }

    @Override
    public void incrementStep() {
        ++this.step;
    }

    @Override
    public IConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isTestOnly() {
        return this.testOnly;
    }

    @Override
    public MProperties getParameters() {
        return this.attributes;
    }

    public long getEstimated() {
        return this.estimated;
    }

    public long getStep() {
        return this.step;
    }

    @Override
    public void addErrorMessage(String msg) {
        if (msg == null) {
            return;
        }
        this.errorMessage = this.errorMessage == null ? msg : String.valueOf(this.errorMessage) + "\n" + msg;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

