/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.core.ITimerTask;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.schedule.MutableSchedulerJob;
import de.mhus.lib.core.schedule.Scheduler;
import de.mhus.lib.core.schedule.SchedulerJob;

public class IntervalJob
extends SchedulerJob
implements MutableSchedulerJob {
    private long interval;

    public IntervalJob(long interval, ITimerTask task) {
        super(task);
        this.interval = interval;
    }

    @Override
    public void doCaclulateNextExecution() {
        this.setNextExecutionTime(System.currentTimeMillis() + this.interval);
    }

    @Override
    public String toString() {
        return String.valueOf(IntervalJob.class.getSimpleName()) + "," + this.interval;
    }

    @Override
    public void doReschedule(Scheduler queue, long time) {
        super.doReschedule(queue, time);
    }

    @Override
    public void setDone(boolean done) {
        super.setDone(done);
    }

    @Override
    public boolean doReconfigure(String config) {
        long l = MCast.tolong(config, -1L);
        if (l > 0L) {
            this.interval = l;
            return true;
        }
        return false;
    }

    @Override
    public void setScheduledTime(long scheduledTime) {
        super.setScheduledTime(scheduledTime);
    }
}

